"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const https_1 = __importDefault(require("https"));
const http_1 = __importDefault(require("http"));
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const fs_1 = __importDefault(require("fs"));
//import HashMap from 'hashmap';
const cookie_parser_1 = __importDefault(require("cookie-parser"));
var net = require('net');
const CRLF = "\r\n";
const END = "\r\n\r\n";
var client = new net.Socket();
const setting_config_1 = require("./config/setting.config");
const _406_1 = require("./lib/view/406");
const module_config_1 = require("./config/module.config");
const Session_1 = require("./lib/model/Session");
const setting = new setting_config_1.Setting();
const app = (0, express_1.default)();
app.use(body_parser_1.default.urlencoded({ extended: true }));
app.use(body_parser_1.default.json());
app.use((0, cookie_parser_1.default)());
app.use(function (req, res, next) {
    res.header("Access-Control-Allow-Origin", "*");
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
    res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    next();
});
app.use((req, res, next) => {
    console.log(req.url);
    let url = req.url.split("?");
    if (url[0] == "/login" || url[0] == '/getaudio' || url[0] == '/gettmpaudio' || url[0] == "/usignup" || url[0] == "/ulogin" || url[0] == "/checksession" || url[0] == "/custom/ssologin" || url[0] == "/custom/getTokenLogin" || url[0] == "/api/user-register" || url[0] == "/custom/getusers" || url[0] == "/custom/onUpdateAddress" || url[0] == "/custom/updateBussnessData") {
        next();
    }
    else {
        if (req.method == "OPTIONS") {
            res.status(200).send();
        }
        else {
            let sess = new Session_1.SessionManagment(req, res, next);
            /* console.log("Main file further "+req.url);
            console.log("Current session key "+req.headers.authorization); */
            sess.GetSession((error, data) => {
                if (error == 1) {
                    module_config_1.cursess.session = data;
                    module_config_1.cursess.error = 0;
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare("Error in session");
                    objv.execute();
                }
                next();
            });
        }
    }
});
//app.use(session({secret:"gventureworksforyou", resave: false, saveUninitialized: false}));
var routes = require('./routes/routes.class'); //importing route
//HTTPS server
if (setting.HTTPS) {
    let serversocket = new https_1.default.Server();
    const options = {
        key: fs_1.default.readFileSync(setting.KEY),
        cert: fs_1.default.readFileSync(setting.CERT)
    };
    serversocket = https_1.default.createServer(options, app);
    app.set("port", process.env.PORT || 3055);
    // app.set("port", setting.config || 3090);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), () => {
        console.log("  App is running at https://localhost:%d in %s mode", app.get("port"));
        console.log("  Press CTRL-C to stop\n");
    });
}
//HTTP server generation setting with complete socket
else {
    let serversocket = new http_1.default.Server();
    serversocket = http_1.default.createServer(app);
    app.set("port", process.env.PORT || setting.PORT);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), () => {
        console.log("  App is running at http://localhost:%d in %s mode", app.get("port"));
        console.log("  Press CTRL-C to stop\n");
    });
}
