"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Payment = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _405_1 = require("../lib/view/405");
const _404_1 = require("../lib/view/404");
const _406_1 = require("../lib/view/406");
const stripepay = require("stripe");
class Payment {
    CheckoutPay(req, res, next) {
        let sdata = JSON.parse(req.body.data);
        console.log("Buy Menutes Method has been called");
        console.log("getting isdetails id", sdata);
        let stipedata = sdata.pdata;
        const stripe = stripepay(sdata.secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                stripe.customers.create({
                    email: stipedata.email,
                    source: sdata.token,
                    metadata: {
                        name: stipedata.fullname,
                        contact: stipedata.contact,
                        city: stipedata.city
                    },
                    shipping: {
                        name: stipedata.fullname,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address,
                            city: stipedata.city
                        }
                    },
                }, function (err, customer) {
                    if (err) {
                        let objv = new _405_1.Res405(res);
                        objv.prepare({ error: "Invalid Card Details" });
                        objv.execute();
                    }
                    else {
                        stripe.charges.create({
                            customer: customer.id,
                            amount: stipedata.amount + '00',
                            currency: "usd",
                            description: "Fax Add Balance"
                        }, function (err, charge) {
                            console.log(err, charge);
                            if (err) {
                                let objv = new _405_1.Res405(res);
                                objv.prepare({ message: "Subscription creation have issues" });
                                objv.execute();
                            }
                            else {
                                console.log("getting response ::::");
                                let final_amount = charge.amount / 100;
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `stripe_payment` (`userid`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `viarecharge`, `created`, `description`, `customerid`) VALUE(" + sessdata.id + ",'" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + final_amount + "', 'Credit Card', '" + charge.created + "', '" + charge.description + "', '" + sessdata.id + "')";
                                obj.prepare();
                                obj.execute((error, result) => {
                                    let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    objn.nonqrysql = "UPDATE `users` SET `tmpbal`= `balance` + " + final_amount + ", `balance`= `balance` + " + final_amount + " WHERE id='" + sessdata.id + "'";
                                    objn.prepare();
                                    objn.execute((error, result1) => {
                                        if (sdata.card_detail > 0) {
                                            objn.nonqrysql = "INSERT INTO `card_details`(`iduser`,`customer_id`,`card_number`,`name`,`cardnumber`,`exp_year`,`exp_month`) VALUE ('" + sessdata.id + "','" + charge.source.customer + "','" + charge.source.id + "','" + charge.source.name + "','" + charge.payment_method_details.card.last4 + "'," + charge.payment_method_details.card.exp_year + "," + charge.payment_method_details.card.exp_month + ")";
                                            objn.prepare();
                                            objn.execute((error, result2) => {
                                            });
                                        }
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Balance Added successfully." });
                                        objv.execute();
                                    });
                                });
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _404_1.Res404(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    Newpayment(req, res, next) {
        console.log("Alll data HERE :::::", req.body.data);
        let sdata = req.body.data.fadata;
        let secret_key = req.body.data.secret_key;
        const stripe = stripepay(secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                stripe.charges.create({
                    customer: sdata.customer_id,
                    amount: sdata.amount + '00',
                    currency: "usd",
                    description: "Fax quick Add Balance"
                }, function (err, charge) {
                    console.log(err, charge);
                    if (err) {
                        let objv = new _405_1.Res405(res);
                        objv.prepare({ message: "Subscription creation have issues" });
                        objv.execute();
                    }
                    else {
                        console.log("getting response ::::", charge);
                        let final_amount = charge.amount / 100;
                        console.log("final amount", final_amount, charge.amount);
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `stripe_payment` (`userid`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `viarecharge`, `created`, `description`, `customerid`) VALUE(" + sessdata.id + ",'" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + final_amount + "', 'Credit Card', '" + charge.created + "', '" + charge.description + "', '" + sessdata.id + "')";
                        obj.prepare();
                        obj.execute((error, result) => {
                            let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            objn.nonqrysql = "UPDATE `users` SET `tmpbal`= `balance` + " + final_amount + ", `balance`= `balance` + " + final_amount + " WHERE id='" + sessdata.id + "'";
                            objn.prepare();
                            objn.execute((error, result1) => {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Balance Added successfully." });
                                objv.execute();
                            });
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Payment = Payment;
