"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Campaign = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const setting_config_1 = require("../config/setting.config");
class Campaign {
    GetNewID(req, res, next) {
        let currdb = new setting_config_1.DataBaseConfig();
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `AUTO_INCREMENT` `index` FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + currdb.NAME + "' AND TABLE_NAME = 'campaign'";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UpdateCampaign(req, res, next) {
        console.log("Posted capm data");
        console.log(req.body.data);
        let sdata = JSON.parse(req.body.data);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `campaign` SET `name`='" + sdata.name + "',`callerid`='" + sdata.callerid + "', `upload_id`=" + sdata.contact + ", `emailid`='" + sdata.emailid + "', `dnc`='" + sdata.dnc + "', `leads`=" + sdata.leads + ", `scheduleddate`='" + sdata.scheduleddate + "', `startdate`='" + sdata.startdate + "', `starthr`='" + sdata.starthr + "', `startmin`='" + sdata.startmin + "', `enddate`='" + sdata.enddate + "', `endhr`='" + sdata.endhr + "', `endmin`='" + sdata.endmin + "', `timezone`='" + sdata.timezone + "',`retry_time`=" + sdata.retry_time + ", `idfaxfile`=" + sdata.idfaxfile + ", `status`=0 WHERE `id`=" + req.query.id;
                obj.prepare();
                obj.execute((error, lastid) => {
                    let obju2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obju2.nonqrysql = "UPDATE `uploads` SET `id_campaign`=-1 WHERE `id_campaign`=" + req.query.id;
                    obju2.prepare();
                    obju2.execute((error, lastid) => {
                        let obju3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obju3.nonqrysql = "UPDATE `uploads` SET `id_campaign`=" + req.query.id + " WHERE `id`=" + sdata.contact;
                        obju3.prepare();
                        obju3.execute((error, lastid) => {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Campaign Updated Successfully." });
                            objv.execute();
                        });
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    CampaignSave(req, res, next) {
        console.log("Posted capm data");
        console.log(req.body.data);
        let sdata = JSON.parse(req.body.data);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `campaign` (`name`,`callerid`, `upload_id`, `emailid`, `dnc`, `leads`, `scheduleddate`, `startdate`, `starthr`, `startmin`, `enddate`, `endhr`, `endmin`, `timezone`,`retry_time`,`iduser`, `idfaxfile`, `status`) VALUES('" + sdata.name + "','" + sdata.callerid + "','" + sdata.contact + "','" + sdata.emailid + "','" + sdata.dnc + "'," + sdata.leads + ",'" + sdata.scheduleddate + "'," + sdata.startdate + "," + sdata.starthr + "," + sdata.startmin + "," + sdata.enddate + "," + sdata.endhr + "," + sdata.endmin + "," + sdata.timezone + "," + sdata.retry_time + "," + sessdata.id + ", " + sdata.idfaxfile + ", " + sdata.status + ")";
                obj.prepare();
                obj.execute((error, lastid) => {
                    if (lastid.insertId > 0) {
                        console.log("Campaign LastID: " + lastid.insertId);
                        var campid = lastid.insertId;
                        let obju2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obju2.nonqrysql = "UPDATE `uploads` SET `id_campaign`=-1 WHERE `id_campaign`=" + campid;
                        obju2.prepare();
                        obju2.execute((error, lastid) => {
                            let obju3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obju3.nonqrysql = "UPDATE `uploads` SET `id_campaign`=" + campid + " WHERE `id`=" + sdata.contact;
                            obju3.prepare();
                            obju3.execute((error, lastid) => {
                                let obju4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obju4.nonqrysql = "UPDATE `leads` SET `status`=0 WHERE `id_upload`=" + sdata.contact;
                                obju4.prepare();
                                obju4.execute((error, lastid) => {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Campaign Added Successfully." });
                                    objv.execute();
                                });
                            });
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Campaign not inserted.", error: lastid });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DeleteCampanign(req, res, next) {
        let idcampaign = req.query.id;
        console.log(req.query.id);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `campaign` WHERE `id`=" + idcampaign;
                obj.prepare();
                obj.execute((error, result) => {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `uploads` SET `id_campaign`=-1 WHERE `id_campaign`=" + idcampaign;
                    obj1.prepare();
                    obj1.execute((error, result) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Campaign Deleted successfully." });
                        objv.execute();
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    RunCampaign(req, res, next) {
        let sdata = JSON.parse(req.body.data);
        let idcampaign = sdata.id;
        console.log(req.body.data);
        let sessiond = new Session_1.SessionManagment(req, res, next);
        sessiond.GetSession((error, session) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `campaign` SET `status`=1 WHERE `id`=" + idcampaign;
                obj.prepare();
                obj.execute((error, updatecamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Campaign Started successfully." });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Campaign = Campaign;
