"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dialer = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
class Dialer {
    constructor() { }
    getLeads(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(sessdata);
                let id = -1;
                if (sessdata.hasOwnProperty('iduser')) {
                    id = sessdata.iduser;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `tbl_leads` SET queued=0 WHERE `user_id` = " + id;
                obj.prepare();
                obj.execute((error, result) => {
                    //console.log(result);
                    //select global filter
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT IFNULL(`global_filter`,'') `global_filter`  FROM `tbl_global_filter` WHERE `user_id` = " + id;
                    obj1.prepare();
                    obj1.execute((error, result1) => {
                        console.log(result1);
                        //update queued leads queued status to 1
                        var glb_fil = "";
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        if (result1.length > 0) {
                            if (result1[0].hasOwnProperty("global_filter")) {
                                glb_fil = result1[0].global_filter;
                                if (result1[0].global_filter.length > 0)
                                    obj2.nonqrysql = "UPDATE `tbl_leads` SET queued=1 WHERE `user_id` = " + id + " AND `disposition` IN ('fresh', 'NC', 'CB') AND `created_date` <= NOW() " + glb_fil;
                                else
                                    obj2.nonqrysql = "UPDATE `tbl_leads` SET queued=1 WHERE `user_id` = " + id + " AND `disposition` IN ('fresh', 'NC', 'CB') AND `created_date` <= NOW()";
                            }
                        }
                        else {
                            obj2.nonqrysql = "UPDATE `tbl_leads` SET queued=1 WHERE `user_id` = " + id + " AND `disposition` IN ('fresh', 'NC', 'CB') AND `created_date` <= NOW()";
                        }
                        obj2.prepare();
                        obj2.execute((error, result2) => {
                            //console.log(result2);
                            //select all leads in queued and unqueued order
                            let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                            obj3.qrysql = "SELECT `id`, `lead_level`, `salse_rep_name`, `created_date`, `disposition`, `didpick`, `dispoattempts`, `uploadstatus`, `dispodate`, `queued`, `callback_time`, `first_name`, `last_name`, `spouse_full_name`, `street_address_1`, `city`, `state`, `zip`, `county`, `email`, `cell_phone`, `phone`, `work_phone`, `birth_date`, `age`, `occupation`, `spouse_full_name`, `spouse_occupation`, `spouse_birth_date`, `spouse_age`, `lender`, `mortgage_amount`, `purchase_refi`, `home_value`, `mortgage_term`, `monthly_mortage_payment`, `beneficiary`, `smoker`, `height`, `weight`, `health_issue`, `spouse_smoker`, `spouse_height`, `spouse_weight`, `spouse_health_issue`, `lead_level`, `assign_date`, `status`, `referrer`, `salse_rep_name`, `lead_type` `lead_script_id`, `comments` FROM (`tbl_leads`) WHERE `user_id` = " + id + " ORDER BY `queued` DESC, `uploadstatus` ASC, `dispodate` ASC, `id` ASC";
                            obj3.prepare();
                            obj3.execute((error, result3) => {
                                //console.log(result3);  
                                var data = [];
                                for (var i = 0; i < result3.length; i++) {
                                    var jsondata = { id: result3[i].id, lead_level: result3[i].lead_level, salse_rep_name: result3[i].salse_rep_name, created_date: result3[i].created_date, disposition: result3[i].disposition, didpick: result3[i].didpick, dispoattempts: result3[i].dispoattempts, queued: result3[i].queued, callback_time: result3[i].callback_time,
                                        edit: { first_name: result3[i].first_name, last_name: result3[i].last_name, spouse_full_name: result3[i].spouse_full_name, street_address_1: result3[i].street_address_1, city: result3[i].city, state: result3[i].state, zip: result3[i].zip, county: result3[i].county, email: result3[i].email, cell_phone: result3[i].cell_phone, phone: result3[i].phone, work_phone: result3[i].work_phone },
                                        personalinfo: { birth_date: result3[i].birth_date, age: result3[i].age, occupation: result3[i].occupation, spouse_occupation: result3[i].spouse_occupation, spouse_birth_date: result3[i].spouse_birth_date, spouse_age: result3[i].spouse_age, lender: result3[i].lender, mortgage_amount: result3[i].mortgage_amount, purchase_refi: result3[i].purchase_refi, home_value: result3[i].home_value, mortgage_term: result3[i].mortgage_term, monthly_mortage_payment: result3[i].monthly_mortage_payment, beneficiary: result3[i].beneficiary, smoker: result3[i].smoker, height: result3[i].height, weight: result3[i].weight, health_issue: result3[i].health_issue, spouse_smoker: result3[i].spouse_smoker, spouse_height: result3[i].spouse_height, spouse_weight: result3[i].spouse_weight, spouse_health_issue: result3[i].spouse_health_issue, lead_level: result3[i].lead_level, assign_date: result3[i].assign_date, status: result3[i].status, referrer: result3[i].referrer, salse_rep_name: result3[i].salse_rep_name },
                                        current_script: { id: result3[i].lead_script_id },
                                        comments: { comments: result3[i].comments } };
                                    data.push(jsondata);
                                }
                                //console.log(JSON.stringify(data));  
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(data);
                                objv.execute();
                            });
                        });
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Dialer = Dialer;
