"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocketIO = void 0;
const setting_config_1 = require("../config/setting.config");
var mysql = require('mysql');
class SocketIO {
    connection;
    constructor(io, client) {
        let db = new setting_config_1.DataBaseConfig();
        let connection = mysql.createConnection({
            host: db.HOST,
            user: db.USER,
            password: db.PASS,
            database: db.NAME
        });
        io.sockets.on('connect', (socket) => {
            console.log('Connected client on port');
            client.on('data', (fs_data) => {
                var data = fs_data.toString();
                console.log('Freeswitch Received Data: ');
                console.log(data);
            });
            function getCampaign(id) {
                let query = "Select `id`, `fullname`, `username`, `password`, `company`, `balance` from `users`";
                connection.query(query, function (error, data) {
                    if (!error) {
                        io.sockets.in(socket.room).emit("campaign", data);
                    }
                    else {
                        console.log("Mysql query error  : " + error + "");
                    }
                });
            }
            socket.on('login', (data) => {
                if (data.length > 0) {
                    var user = JSON.parse(data);
                    socket.session = user.session;
                    socket.room = user.userid;
                    socket.join(user.extension);
                    console.log("Panel login with session :" + socket.session + " and room: " + socket.room);
                }
                else {
                    console.log("User Login with Blank Data");
                }
            });
            socket.on('refreshcamp', (cdata) => {
                if (cdata.length > 0) {
                    console.log("Compaign has been started");
                    var data = JSON.parse(cdata);
                    console.log(data);
                    getCampaign(data.id);
                }
                else {
                    console.log("Campaign start with Null Data");
                }
            });
            socket.on('disconnect', () => {
                client.on('close', function () {
                    console.log("Manager Connection has been closed");
                });
                console.log(socket.room + ' assigned room ' + socket.session + ' has been removed');
                socket.leave(socket.room);
            });
        });
    }
}
exports.SocketIO = SocketIO;
