"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Leads = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const ModelCsvUpload_1 = require("../lib/model/ModelCsvUpload");
const fs_1 = __importDefault(require("fs"));
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const _406_1 = require("../lib/view/406");
const Session_1 = require("../lib/model/Session");
const setting_config_1 = require("../config/setting.config");
const Downloadview_1 = require("../lib/view/Downloadview");
var md5 = require('md5');
class Leads {
    UploadLeadsFile(req, res, next) {
        console.log("Leads Upload called");
        console.log(req.file);
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let objfile = new ModelCsvUpload_1.ModelCsvUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `uploads` SET `iduser`=" + sessdata.id + ", `id_campaign`=" + sdata.id_campaign + ", `leads`=0, `name`='" + fdata[0] + "',`filename`='" + fdata[0] + "', `filepath`='" + fdata[1] + "'";
                obj.prepare();
                obj.execute((error, lastid) => {
                    let LASTID = lastid.insertId;
                    let firstrow1 = fs_1.default.readFileSync(req.file.path).toString().split('\n');
                    let firstrow = firstrow1[0].split('\r');
                    let str = '';
                    /* if(!firstrow[0].match(/[a-z]/))
                    {
                        console.log("Header Processed");
                        str='';
                    }
                    else
                    {
                        console.log("Header Skipped");
                        str='IGNORE 1 LINES';
                    } */
                    let objleads = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objleads.nonqrysql = "LOAD DATA LOCAL INFILE '" + fdata[1] + fdata[0] + "' INTO TABLE `leads` LINES TERMINATED BY '\r\n' " + str + " (@col1) set `id_upload`=" + LASTID + ", `iduser`=" + sessdata.id + ", `phone`=trim(@col1)";
                    objleads.prepare();
                    objleads.execute((error, result) => {
                        console.log(result);
                        obj.nonqrysql = "UPDATE `uploads` SET `leads`='" + result.affectedRows + "' WHERE `id`=" + LASTID;
                        obj.prepare();
                        obj.execute((error, afterUpdate) => {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Leads Data Inserted Successfully.", insertedid: LASTID, filename: fdata[0], total: result });
                            objv.execute();
                        });
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DeleteLead(req, res, next) {
        console.log(req.query);
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `uploads` WHERE `id`=" + sdata.id;
                obj.prepare();
                obj.execute((error, result) => {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "DELETE FROM `leads` WHERE `id_upload`=" + sdata.id;
                    obj1.prepare();
                    obj1.execute((error, result) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Lead List Deleted Successfully." });
                        objv.execute();
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UploadDncFile(req, res, next) {
        console.log("File DNC Upload called");
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let objfile = new ModelCsvUpload_1.ModelCsvUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `dnc_list` SET `iduser`=" + sessdata.id + ", `filename`='" + fdata[0] + "'";
                obj.prepare();
                obj.execute((error, lastid) => {
                    // console.log("Leads Uploaded Successfully");
                    console.log("Upload ID: " + lastid.insertId);
                    let LASTID = lastid.insertId;
                    let objleads = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    //Read first line to check where it is need ti insert or not. 
                    let firstrow1 = fs_1.default.readFileSync(req.file.path).toString().split('\n');
                    let firstrow = firstrow1[0].split('\r');
                    let str = '';
                    // console.log(firstrow[0]);
                    /* if(!firstrow[0].match(/[a-z]/)){
                        console.log("Header Processed");
                        str='';
                    }else{
                        console.log("Header Skipped");
                        str='IGNORE 1 LINES';
                    } */
                    objleads.nonqrysql = "LOAD DATA LOCAL INFILE '" + fdata[1] + fdata[0] + "' INTO TABLE `dnc` LINES TERMINATED BY '\r\n' " + str + " (@col1) set `list_id`=" + LASTID + ", `iduser`=" + sessdata.id + ", `number`=trim(@col1)";
                    objleads.prepare();
                    objleads.execute((error, result) => {
                        console.log(result);
                        obj.nonqrysql = "UPDATE `dnc_list` SET `numbers`='" + result.affectedRows + "' WHERE `id`=" + LASTID;
                        obj.prepare();
                        obj.execute((error, afterUpdate) => {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "DNC Data Inserted Successfully.", insertedid: lastid.insertId, filename: fdata[0], total: result });
                            objv.execute();
                        });
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DncListDelete(req, res, next) {
        console.log(req.query);
        var sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `dnc_list` WHERE `id`=" + sdata.id;
                obj.prepare();
                obj.execute((error, result) => {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "DELETE FROM `dnc` WHERE `list_id`=" + sdata.id;
                    obj1.prepare();
                    obj1.execute((error, result) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DNC List Deleted Successfully." });
                        objv.execute();
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    ExportLead(req, res, next) {
        console.log(req.query.filename);
        let file = new Date().getTime() + '_leads';
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let mysqlfilePath = '/var/www/html/downloads/';
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT 'Phone' UNION ALL SELECT `phone` FROM `leads` WHERE `iduser`=" + sessdata.id + " LIMIT 100000 INTO OUTFILE '" + mysqlfilePath + file + ".csv' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n'";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log("Leads Data updated Successfully");
                    let objv = new Downloadview_1.DownloadData(res);
                    objv.prepare({ filename: file, type: 'csv', path: mysqlfilePath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DownloadXCL(req, res, next) {
        console.log(req.query.filename);
        var tmp = JSON.parse(req.query.filename);
        var hashfilename = md5(tmp.filename + Date.now());
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let dlurl = new setting_config_1.downloadUrl();
            let mysqlfilePath = dlurl.MYSQLDIR;
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT 'Caller', 'Number', 'Start', 'Answer', 'End', 'Duration', 'Image-Resolution', 'Success', 'Result', 'Pages-Sent', 'Total-Pages', 'Filename', 'Transfer-Rate' UNION ALL SELECT `caller_id_number`,`dialed_number`,DATE_FORMAT(FROM_UNIXTIME(`cdr`.`start_epoch`),'%m-%d-%Y %H:%i:%s')`start`,DATE_FORMAT(FROM_UNIXTIME(`cdr`.`answer_epoch`),'%m-%d-%Y %H:%i:%s')`answer`, DATE_FORMAT(FROM_UNIXTIME(`cdr`.`end_epoch`),'%m-%d-%Y %H:%i:%s')`end`, `billsec`, `fax_file_image_resolution`,`fax_success`,`fax_result_code`,`fax_document_transferred_pages`,`fax_document_transferred_pages`,`fax_filename`,`fax_transfer_rate` FROM `cdr` WHERE `fax_document_transferred_pages` > 0 AND `presence_id`=" + tmp.id + " LIMIT 100000 INTO OUTFILE '" + mysqlfilePath + hashfilename + ".csv' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n'";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log("Leads Data updated Successfully");
                    let objv = new Downloadview_1.DownloadData(res);
                    objv.prepare({ filename: hashfilename, type: 'csv', path: mysqlfilePath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Downloadfailedreportexc(req, res, next) {
        console.log(req.query.filename);
        var tmp = JSON.parse(req.query.filename);
        console.log("temp:::", tmp);
        var hashfilename = md5(tmp.filename + Date.now());
        console.log("hassfile::::::", hashfilename);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let dlurl = new setting_config_1.downloadUrl();
            let mysqlfilePath = dlurl.MYSQLDIR;
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT 'Caller', 'Number', 'Start', 'Answer', 'End', 'Duration', 'Success',  'Pages-Sent', 'Total-Pages', 'Status' UNION ALL SELECT `caller_id_number`,`dialed_number`,DATE_FORMAT(FROM_UNIXTIME(`cdr`.`start_epoch`),'%m-%d-%Y %H:%i:%s')`start`,DATE_FORMAT(FROM_UNIXTIME(`cdr`.`answer_epoch`),'%m-%d-%Y %H:%i:%s')`answer`, DATE_FORMAT(FROM_UNIXTIME(`cdr`.`end_epoch`),'%m-%d-%Y %H:%i:%s')`end`, `billsec`, `fax_success`, `fax_document_transferred_pages`,`fax_document_transferred_pages`,`hangup_cause` FROM `cdr` WHERE `fax_document_transferred_pages` < 1 AND `presence_id`=" + tmp.id + " AND `duration`>0 LIMIT 1000000 INTO OUTFILE '" + mysqlfilePath + hashfilename + ".csv' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n'";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log("Leads Data updated Successfully");
                    let objv = new Downloadview_1.DownloadData(res);
                    objv.prepare({ filename: hashfilename, type: 'csv', path: mysqlfilePath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    DownloadRemLeads(req, res, next) {
        console.log(req.query.filename);
        var tmp = JSON.parse(req.query.filename);
        var hashfilename = md5(tmp.filename + Date.now());
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let dlurl = new setting_config_1.downloadUrl();
            let mysqlfilePath = dlurl.MYSQLDIR;
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT 'Number' UNION ALL SELECT `phone` FROM `leads` WHERE `status` = 0 AND `id_upload`=(SELECT `upload_id` FROM `campaign` WHERE `id`=" + tmp.id + " LIMIT 1) INTO OUTFILE '" + mysqlfilePath + hashfilename + ".csv' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n'";
                obj.prepare();
                obj.execute((error, result) => {
                    console.log("Leads Data updated Successfully");
                    let objv = new Downloadview_1.DownloadData(res);
                    objv.prepare({ filename: hashfilename, type: 'csv', path: mysqlfilePath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Leads = Leads;
