"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reports = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
class Reports {
    constructor() { }
    HomeWidgets(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "SELECT (SELECT COUNT(*) FROM campaign WHERE `status`=1 AND iduser=" + sessdata.id + ")`campaign`, COUNT(*)dialed, SUM(IF(fax_success=0, 1, 0))failed, (SUM(`billsec`)/60)`minutes` FROM `cdr` WHERE iduser=" + sessdata.id + " AND DATE_FORMAT(FROM_UNIXTIME(`start_epoch`), '%m-%d-%Y')='DATE_FORMAT(NOW(), '%m-%d-%Y')'";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    LiveCalls(req, res, next) {
        let where = req.query.where;
        console.log(where);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // let cdr=sessdata.id+"_"+sessdata.username;
                let cdr = "cdr_" + sessdata.id + "_" + sessdata.username;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (where !== undefined) {
                    obj.nonqrysql = "SELECT `name`, `state`, `cid_name`, `dest`, `direction`, `callee_name`, `callee_num` FROM `channels` WHERE `accountcode`='" + sessdata.id + "' AND " + where + "";
                }
                else {
                    obj.nonqrysql = "SELECT `name`, `state`, `cid_name`, `dest`, `direction`, `callee_name`, `callee_num` FROM `channels` WHERE `accountcode`=" + sessdata.id;
                }
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Live Calls List.", records: result });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Reports = Reports;
