"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelListView = void 0;
const ModelObject_1 = require("./ModelObject");
class ModelListView extends ModelObject_1.ModelObject {
    prepare() {
        var ret = true;
        //console.log(req);
        if (this.query.table.toString().length < 1) {
            console.log("Table is not defined properly.");
            ret = false;
        }
        if (this._data.length > 1) {
            this.query.field = this._data;
        }
        else {
            console.log("SELECT fields are not defined properly.");
            ret = false;
        }
        if (this.req.query.hasOwnProperty('filter')) {
            if (this._isfilter) {
                this.query.filter = Object.assign(JSON.parse(this.req.query.filter), this._filter);
                this.query.isfilter = true;
            }
            else {
                this.query.filter = JSON.parse(this.req.query.filter);
                this.query.isfilter = true;
            }
        }
        else {
            if (this.req.query.hasOwnProperty('id')) {
                if (this._isfilter) {
                    this.query.filter = Object.assign({ id: this.req.query.id }, this._filter);
                    this.query.isfilter = true;
                }
                else {
                    this.query.filter = { id: this.req.query.id };
                    this.query.isfilter = true;
                }
            }
            else {
                if (this._isfilter) {
                    this.query.filter = this._filter;
                    this.query.isfilter = true;
                }
            }
        }
        return ret;
    }
    execute(callback) {
        this.query.prepare();
        this.query.DataSet((err, data) => {
            this.respond(err, data, callback);
        });
    }
}
exports.ModelListView = ModelListView;
