"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelLogin = void 0;
const ModelObject_1 = require("./ModelObject");
const module_config_1 = require("../../config/module.config");
const _403_1 = require("../view/403");
const md5_1 = __importDefault(require("md5"));
class ModelLogin extends ModelObject_1.ModelObject {
    prepare() {
        var ret = true;
        let config = new module_config_1.modLogin();
        console.log(this.req.body);
        let paramdata; //={username:"", password:""};
        try {
            paramdata = JSON.parse(this.req.body.data);
        }
        catch (error) {
            console.log(error);
            paramdata = this.req.body.data;
        }
        this.table = config.data.table;
        this.query.field = config.data.selectfield;
        let uname = "", passwd = "";
        if (paramdata.hasOwnProperty(config.data.postfield[0].field)) {
            uname = paramdata[config.data.postfield[0].field];
        }
        else {
            console.log(config.data.postfield[0].field + " is not found");
            let objv = new _403_1.Res403(this.res);
            objv.prepare({ error: "Invalid Username/Password, Kindly check again." });
            objv.execute();
            return false;
        }
        if (paramdata.hasOwnProperty(config.data.postfield[1].field)) {
            if (config.data.md5)
                passwd = (0, md5_1.default)(paramdata[config.data.postfield[1].field]);
            else
                passwd = paramdata[config.data.postfield[1].field];
        }
        else {
            console.log(config.data.postfield[1].field + " is not found");
            let objv = new _403_1.Res403(this.res);
            objv.prepare({ error: "Invalid Username/Password, Kindly check again." });
            objv.execute();
            return false;
        }
        let loginfilter = null;
        if (config.data.filter != undefined) {
            console.log("TOSHU" + config.data.filter);
            let tmp = "";
            Object.entries(config.data.filter).forEach(([key, value]) => { console.log(key, value); tmp += "\"" + key + "\":\"" + value + "\","; });
            loginfilter = tmp.replace(/,\s*$/, "");
        }
        this.query.isfilter = true;
        let dbfield = config.data.tablefield;
        let filter = '';
        if (loginfilter !== null) {
            filter = "{\"" + dbfield[0] + "\":\"" + uname + "\", \"" + dbfield[1] + "\":\"" + passwd + "\"," + loginfilter + "}";
        }
        else {
            filter = "{\"" + dbfield[0] + "\":\"" + uname + "\", \"" + dbfield[1] + "\":\"" + passwd + "\"}";
        }
        console.log(filter);
        this.query.filter = JSON.parse(filter);
        this.query.isfilter = true;
        return ret;
    }
    execute(callback) {
        this.query.prepare();
        this.query.Row((err, data) => {
            console.log(data);
            if (err > 1)
                err = 8;
            if (err == 1)
                err = 2;
            this.respond(err, data, callback);
        });
    }
}
exports.ModelLogin = ModelLogin;
