"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelObject = void 0;
const NonQuery_1 = require("./NonQuery");
const Query_1 = require("./Query");
const log_1 = require("./log");
const _405_1 = require("../view/405");
const _403_1 = require("../view/403");
class ModelObject {
    query;
    nonquery;
    _isdata = false;
    _data;
    _filter;
    _isfilter = false;
    log;
    req;
    res;
    constructor(req, res) {
        this.log = new log_1.Log();
        this.query = new Query_1.Query();
        this.nonquery = new NonQuery_1.NonQuery();
        this.req = req;
        this.res = res;
    }
    get data() {
        return this._data;
    }
    set data(val) {
        if (val == null)
            return;
        if (val == "")
            return;
        this._data = val;
        this._isdata = true;
    }
    /* public get isdata(){
        return this._isdata;
    }
    public set isdata(val){
        this._isdata=val;
    } */
    get type() {
        return this.nonquery.type;
    }
    set type(val) {
        this.nonquery.type = val;
    }
    get qrysql() {
        return this.query.sql;
    }
    set qrysql(val) {
        if (val == null)
            return;
        if (val == "")
            return;
        this.query.isSQL = true;
        this.query.sql = val;
    }
    get nonqrysql() {
        return this.nonquery.sql;
    }
    set nonqrysql(val) {
        this.nonquery.sql = val;
    }
    get filter() {
        return this._filter;
    }
    set filter(val) {
        if (val == null)
            return;
        if (val == "")
            return;
        this._isfilter = true;
        this._filter = val;
    }
    get isfilter() {
        return this._isfilter;
    }
    set isfilter(val) {
        this._isfilter = val;
    }
    get where() {
        return this.query.where;
    }
    set where(val) {
        this.query.where = val;
    }
    get group() {
        return this.query.group;
    }
    set group(val) {
        if (val == null)
            return;
        if (val == "")
            return;
        this.query.isgroup = true;
        this.query.group = val;
    }
    get order() {
        return this.query.order;
    }
    set order(val) {
        if (val == null)
            return;
        if (val == "")
            return;
        this.query.isorder = true;
        this.query.order = val;
    }
    get limit() {
        return this.query.limit;
    }
    set limit(val) {
        if (val == null)
            return;
        if (val == -1)
            return;
        this.query.limit = val;
    }
    get table() {
        return this.query.table;
    }
    set table(val) {
        this.query.table = val;
        this.nonquery.table = val;
    }
    respond(err, data, callback) {
        switch (err) {
            case 1:
                {
                    callback(err, data);
                    break;
                }
            case 2:
                { //Login functionality need to implement
                    callback(err, data);
                    break;
                }
            case 5:
                {
                    let objv = new _405_1.Res405(this.res);
                    objv.prepare({ error: "No file Uploaded or Invalid file format" });
                    objv.execute();
                    break;
                }
            case 8:
                {
                    let objv = new _403_1.Res403(this.res);
                    objv.prepare({ error: "Invalid login credentials username/password" });
                    objv.execute();
                    break;
                }
            case 10:
                {
                    let objv = new _405_1.Res405(this.res);
                    objv.prepare({ error: "No file Uploaded or Invalid file format" });
                    objv.execute();
                    break;
                }
        }
    }
}
exports.ModelObject = ModelObject;
