"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelPdfUpload = void 0;
const ModelObject_1 = require("./ModelObject");
const setting_config_1 = require("../../config/setting.config");
var fs = require('fs');
class ModelPdfUpload extends ModelObject_1.ModelObject {
    constructor(req, res) {
        super(req, res);
        this.type = "INSERT";
    }
    fileUpload() {
        /* console.log(this.req.file);
        var target_path = process.cwd() + "/uploads/" + this.req.file.originalname;
        var tmp_path = this.req.file.path;
        var src = fs.createReadStream(tmp_path);
        var dest = fs.createWriteStream(target_path);
        src.pipe(dest);
        var data = [this.req.file.originalname, this.req.file.path];
        return data; */
        console.log(this.req.file);
        var uploaddir = new setting_config_1.UploadDirectory();
        var fullname = this.req.file.originalname.split(".");
        var finelfile = fullname[0] + "_" + (new Date().getTime()) + '.' + fullname[1];
        var target_path = uploaddir.UPLOADSDIR + finelfile;
        var tmp_path = this.req.file.path;
        var src = fs.createReadStream(tmp_path);
        var dest = fs.createWriteStream(target_path);
        src.pipe(dest);
        var data = [finelfile, uploaddir.UPLOADSDIR, tmp_path];
        return data;
    }
    prepare() {
        return true;
    }
    execute(callback) {
    }
}
exports.ModelPdfUpload = ModelPdfUpload;
