"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionManagment = exports.CurrentSession = void 0;
const MysqlManager_1 = require("./MysqlManager");
const module_config_1 = require("../../config/module.config");
const _403_1 = require("../view/403");
const _406_1 = require("../view/406");
const md5_1 = __importDefault(require("md5"));
class CurrentSession {
    __session;
    __error;
    __message;
    __requestURI = "";
    __config;
    __type;
    get requestURI() {
        return this.__requestURI;
    }
    set requestURI(val) {
        this.__requestURI = val;
    }
    get config() {
        return this.__config;
    }
    set config(val) {
        this.__config = val;
    }
    get type() {
        return this.__type;
    }
    set type(val) {
        this.__type = val;
    }
    get session() {
        return this.__session;
    }
    set session(val) {
        this.__session = val;
    }
    get error() {
        return this.__error;
    }
    set error(val) {
        this.__error = val;
    }
    get message() {
        return this.__message;
    }
    set message(val) {
        this.__message = val;
    }
}
exports.CurrentSession = CurrentSession;
class SessionManagment {
    connection;
    req;
    res;
    next;
    config = new module_config_1.modSession();
    constructor(req, res, next) {
        this.req = req;
        this.res = res;
        this.next = next;
        this.connection = new MysqlManager_1.MysqlManager();
    }
    SetSession(data, callback) {
        this.connection.Open();
        let key = (0, md5_1.default)(JSON.stringify(data) + (new Date().getUTCMilliseconds()));
        let tmp = "{\"" + this.config.data.session + "\": \"" + key + "\"}";
        data.authkey = key;
        let field = JSON.parse(tmp);
        let sessdata = Object.assign(data, field);
        this.connection.data = sessdata;
        this.connection.sql = "INSERT INTO `" + this.config.data.table + "` SET ?  ON DUPLICATE KEY UPDATE `authkey`='" + data.authkey + "'";
        module_config_1.sessiondata.set(data.authkey, sessdata);
        this.connection.Execute((err, data) => {
            if (err == 1) {
                callback(err, data);
            }
            else {
                let objv = new _403_1.Res403(this.res);
                objv.prepare({ error: "User session cannot created" });
                objv.execute();
            }
            this.connection.Close();
        });
    }
    GetSession(callback) {
        let akey = this.req.headers.authorization;
        console.log("Current authorization key " + akey);
        if (akey == undefined || akey == "") {
            let objv = new _406_1.Res406(this.res);
            objv.prepare({ error: "Invalid session is called to access" });
            objv.execute();
            return;
            //callback(406,"Invalid session is called to access");
        }
        if (module_config_1.sessiondata.has(akey)) {
            console.log(module_config_1.sessiondata.get(akey));
            callback(1, module_config_1.sessiondata.get(akey));
            return;
        }
        console.log("============================Session not exists===================================");
        this.connection.Open();
        this.connection.sql = "SELECT ?? FROM `" + this.config.data.table + "` WHERE ?";
        this.connection.data = [this.config.data.field, { authkey: akey }];
        this.connection.Row((err, data) => {
            console.log("============================Session not exists with data===================================");
            if (err == 1) {
                module_config_1.sessiondata.set(akey, data);
                callback(err, data);
            }
            else {
                let objv = new _406_1.Res406(this.res);
                objv.prepare({ error: "Invalid session is called to access" });
                objv.execute();
                //callback(406,"Invalid session is called to access");
            }
            this.connection.Close();
            console.log("============================Session not exists with data===================================");
        });
        console.log("============================Session not exists===================================");
    }
    // public GetSession(callback: (error: any, data: any) => void) {
    //     let akey: any = this.req.headers.authorization;
    //     console.log('token key:', akey)
    //     const request = require('request');
    //     var options = {
    //         'method': 'POST',
    //         'url': `${centra_url}/api/validate-token`,
    //         'headers': {
    //             'accept': ' */*',
    //             'Authorization': `Bearer ${akey}`,
    //             'X-CSRF-TOKEN': ''
    //         },
    //         formData: {
    //             'scope': 'Email Broadcasting'
    //         }
    //     };
    //     request(options, (error: any, response: any) => {
    //         if (error == null) {
    //             var newval = JSON.parse(response.body);
    //             if (newval.status_code == 200) {
    //                 if (sessiondata.has(akey)) {
    //                     console.log(sessiondata.get(akey));
    //                     callback(1, sessiondata.get(akey));
    //                     return;
    //                 }
    //                 console.log("============================Session not exists===================================");
    //                 this.connection.Open();
    //                 this.connection.sql = "SELECT ?? FROM `" + this.config.data.table + "` WHERE ?";
    //                 this.connection.data = [this.config.data.field, { authkey: akey }];
    //                 this.connection.Row((err: any, data: any) => {
    //                     console.log("============================Session not exists with data===================================");
    //                     if (err == 1) {
    //                         sessiondata.set(akey, data);
    //                         callback(err, data);
    //                     }
    //                     else {
    //                         let objv = new Res406(this.res);
    //                         objv.prepare({ error: "Invalid session is called to access" });
    //                         objv.execute();
    //                     }
    //                     this.connection.Close();
    //                     console.log("============================Session not exists with data===================================");
    //                 });
    //                 console.log("============================Session not exists===================================");
    //             } else {
    //                 let objv = new Res406(this.res);
    //                 objv.prepare({ error: "Invalid session is called to access" });
    //                 objv.execute();
    //             }
    //         } else {
    //             let objv = new Res406(this.res);
    //             objv.prepare({ error: "Invalid session is called to access" });
    //             objv.execute();
    //         }
    //     });
    // }
    DeleteSession(callback) {
        this.connection.Open();
        this.connection.sql = " DELETE FROM `" + this.config.data.table + "` WHERE `" + this.config.data.session + "`='" + this.req.headers.authorization + "'";
        module_config_1.sessiondata.remove(this.req.headers.authorization);
        this.connection.Delete((err, data) => {
            /*  let objv = new Res406(this.res);
             objv.prepare({error: "Invalid session authorization"});
             objv.execute(); */
            callback(err, data);
            this.connection.Close();
        });
    }
    getdata(data, val) {
        Object.entries(data).forEach(([key, value]) => { console.log(key, value); if (key == val)
            return value; });
    }
}
exports.SessionManagment = SessionManagment;
