'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.type = void 0;
const AppRoute_1 = require("../lib/AppRoute");
const setting_config_1 = require("../config/setting.config");
const user_class_1 = require("../include/user.class");
const campaign_class_1 = require("../include/campaign.class");
const leads_class_1 = require("../include/leads.class");
const fileupload_class_1 = require("../include/fileupload.class");
const Payment_class_1 = require("../include/Payment.class");
const reports_class_1 = require("../include/reports.class");
const webapi_class_1 = require("../include/webapi.class");
var multer = require('multer');
var uploaddir = new setting_config_1.UploadDirectory();
var upload = multer({ dest: uploaddir.UPLOADSDIR });
exports.type = upload.single('filename');
module.exports = function (app) {
    var upload = multer({ dest: uploaddir.UPLOADSDIR });
    var type = upload.single('filename');
    var webapi = new webapi_class_1.WebApi();
    app.route("/ulogin").post(webapi.WebLogin);
    app.route("/usignup").post(webapi.userSignup);
    app.route("/checksession").get(webapi.CheckSession);
    app.route("/contactus").post(webapi.ContactUs);
    app.route("/custom/ssologin").post(webapi.ssologin);
    app.route("/custom/getTokenLogin").get(webapi.getTokenLogin);
    app.route("/customerlogout").get(webapi.logoutpanel);
    app.route("/api/user-register").post(webapi.registeruser);
    app.route("/custom/getusers").post(webapi.getUserStatus);
    app.route("/custom/onUpdateAddress").post(webapi.onUpdateAddress);
    app.route("/custom/updateBussnessData").post(webapi.updateBussnessData);
    var cust = new user_class_1.Users();
    app.put("/custom/changepassword", cust.ChangePassword);
    app.get("/gettoken", cust.GetToken);
    app.post("/custom/addrecharge", cust.AddRecharge);
    var camp = new campaign_class_1.Campaign();
    app.get("/custom/getnewid", camp.GetNewID);
    app.post("/custom/campaignsave", camp.CampaignSave);
    app.put("/custom/updatecampaign", camp.UpdateCampaign);
    app.delete("/custom/deletecampaign", camp.DeleteCampanign);
    app.put("/custom/runcampaign", camp.RunCampaign);
    let leads = new leads_class_1.Leads();
    app.post("/uploads", type, leads.UploadLeadsFile);
    app.get("/downloadleadscsv", type, leads.ExportLead);
    app.post("/uploads/dncupload", type, leads.UploadDncFile);
    app.delete("/dnclist", leads.DncListDelete);
    app.route('/download/report').post(leads.DownloadXCL);
    app.route('/download/failedreport').post(leads.Downloadfailedreportexc);
    app.route('/download/remainleads').post(leads.DownloadRemLeads);
    let fileupload = new fileupload_class_1.Fileupload();
    app.post("/fileupload", type, fileupload.UploadFile);
    app.post('/download/pdf', fileupload.DownloadPDF);
    app.post('/download/tiff', fileupload.DownloadTIF);
    app.post('/download/png', fileupload.DownloadPNG);
    let payment = new Payment_class_1.Payment();
    app.post("/custom/savepayment", payment.CheckoutPay);
    app.post("/custom/addBalance", payment.Newpayment);
    let report = new reports_class_1.Reports();
    app.get("/custom/homewidget", report.HomeWidgets);
    var obj = new AppRoute_1.AppRoute();
    app.get("/[a-z]{1,20}", obj.getMethod);
    app.post("/[a-z]{1,20}", obj.postMethod);
    app.put("/[a-z]{1,20}", obj.putMethod);
    app.delete("/[a-z]{1,20}", obj.deleteMethod);
    app.patch("/[a-z]{1,20}", obj.patchMethod);
};
