"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.APIBase = void 0;
// import { ModelRawQuery } from "../lib/model/RawQuery";
// import { Socket } from "net";
// import { VoiceServer } from "../config/setting.config";
const markError_1 = require("./markError");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
// import { RawView } from "../lib/view/RawView";
// var request = require('request');
// const vs_server = new VoiceServer();
// const prefix = vs_server.Prefix;
class APIBase {
    constructor() {
    }
    // public getLRN(lrn_detail: any): boolean {
    //   if (lrn_detail.hasOwnProperty('errors')) {
    //     if (lrn_detail.errors[0] == "LRN Not Found.") {
    //       return true;
    //     }
    //     else
    //       return false;
    //   }
    //   else
    //     return false;
    // }
    // public getRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    //   let catagory = category == 'TF' ? "toll_free_number" : "local_number";
    //   let obj1 = new ModelRawQuery(req, res);
    //   obj1.qrysql = "SELECT `rate` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + catagory + "' AND `type`='" + type + "' LIMIT 1";
    //   obj1.prepare()
    //   obj1.execute((err, rates) => {
    //     callback(err, rates)
    //   });
    // }
    // public getRateCenter(req: Request, res: Response, npa: any, nxx: any, callback: (err: any, data: any) => void) {
    //   let obj = new ModelRawQuery(req, res);
    //   obj.qrysql = "SELECT   `rc_abbre`, `loc_state` FROM `did_location_info` WHERE `npa`='" + npa + "'  AND `nxx`='" + nxx + "'";
    //   obj.prepare();
    //   obj.execute((err, ratecenter_state) => {
    //     if (ratecenter_state.length > 0) {
    //       callback('', ratecenter_state)
    //     } else {
    //       callback(err, '')
    //     }
    //   });
    // }
    // public verifyBrand(req: Request, res: Response, npa: any, callback: (err: any, data: any) => void) {
    //   let obj = new ModelRawQuery(req, res);
    //   obj.qrysql = "SELECT   `brand_name` FROM `brand` WHERE `idaccount`=''";
    //   obj.prepare();
    //   obj.execute((err, ratecenter_state) => {
    //     if (ratecenter_state.length > 0) {
    //       callback('', ratecenter_state)
    //     } else {
    //       callback(err, '')
    //     }
    //   });
    // }
    // public verifyCampagin(req: Request, res: Response, npa: any, nxx: any, callback: (err: any, data: any) => void) {
    //   let obj = new ModelRawQuery(req, res);
    //   obj.qrysql = "SELECT   `idbrand` FROM `campaign` WHERE `npa`='" + npa + "'";
    //   obj.prepare();
    //   obj.execute((err, ratecenter_state) => {
    //     if (ratecenter_state.length > 0) {
    //       callback('', ratecenter_state)
    //     } else {
    //       callback(err, '')
    //     }
    //   });
    // }
    // public getLrnDetails(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
    //   did = "" + did + "";
    //   let len = did.length - 10;
    //   let number = did.slice(len, did.length);
    //   let npa = number.slice(0, 3);
    //   let nxx = number.slice(3, 6);
    //   let obj1 = new ModelRawQuery(req, res);
    //   obj1.qrysql = "SELECT *  FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
    //   obj1.prepare()
    //   obj1.execute((err, lrn_details) => {
    //     if (lrn_details.length > 0) {
    //       callback('', lrn_details)
    //     } else {
    //       callback(err, '')
    //     }
    //   });
    // }
    generateInsertQuery(payload, funDetail) {
        if (!payload || Object.keys(payload).length === 0) {
            console.log({ status: 504, message: "Payload is empty for " + funDetail.logName + ' from function ' + funDetail.functionName });
            return '';
        }
        else {
            const setQuery = Object.entries(payload).map(([key, value]) => {
                switch (typeof value) {
                    case "string":
                        return `\`${key}\` = '${(0, markError_1.parseBody)(value)}'`;
                    case "number":
                        return `\`${key}\` = '${(0, markError_1.setToZero)(value)}'`;
                    case "boolean":
                        return `\`${key}\` = '${value ? 'true' : 'false'}'`;
                    case "object":
                        return value === null ? `\`${key}\` = ''` : `\`${key}\` = '${JSON.stringify(value)}'`;
                    case "undefined":
                    default:
                        return `\`${key}\` = ''`;
                }
            }).join(", ");
            return `INSERT INTO \`${funDetail.tableName}\` SET ${setQuery};`;
        }
    }
    insertLog(req, res, payload, callback) {
        console.log("The " + payload.funDetail.logName + " Log is generating for ", payload.funDetail.functionName);
        if (payload.data && Object.keys(payload.data).length > 0) {
            if (!payload.data || Object.keys(payload.data).length === 0) {
                console.log({ status: 504, message: payload.funDetail.logName + " Log Data Not Available" });
                return;
            }
            try {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let qry = this.generateInsertQuery(payload.data, payload.funDetail);
                if (qry) {
                    obj.nonqrysql = qry;
                    console.log("Generated Query:", obj.nonqrysql);
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            console.log({ status: 200, message: payload.funDetail.logName + " Log Inserted for function " + payload.funDetail.functionName });
                            callback(1, error);
                        }
                        else {
                            callback(0, result);
                            console.log({ status: 502, message: payload.funDetail.logName + " Log Not Inserted for function " + payload.funDetail.functionName });
                        }
                    });
                }
                else {
                    console.log({ status: 506, message: payload.funDetail.logName + " Log Query Not created for function " + payload.funDetail.functionName });
                }
            }
            catch (err) {
                console.error(payload.funDetail.functionName + " =:> Error generating query for :", payload.funDetail.logName, "Log =>", err.message);
            }
        }
    }
}
exports.APIBase = APIBase;
