"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const multer1 = require('multer');
const setting_config_1 = require("../config/setting.config");
const MIME_TYPE_MAP1 = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};
const storage1 = multer1.diskStorage({
    destination: (req, file, cb) => {
        //let upload: any = '';
        // if (req.get('origin') == "https://preprod.crmdialer.us" || req.get('origin') == "https://portal.signalmash.com" || req.get('origin') == "https://api.crmdialer.us" || req.get('origin') == "https://doc.signalmash.com") {
        //     upload = '/var/www/html/signalmash_mms';
        // } else {
        //     upload = 'uploads';
        // }
        let mmsdir = new setting_config_1.UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, mmsdir.MMSUPLOADS);
    },
    filename: (req, file, cb) => {
        const name = file.originalname.toLowerCase().split(' ').join('_');
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, Date.now() + '-' + name);
    }
});
module.exports = multer1({ storage: storage1 }).single('ATTACHMENT');
