'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.type = void 0;
const AppRoute_1 = require("../lib/AppRoute");
const tiermanagement_class_1 = require("../include/tiermanagement.class");
const usermanagement_class_1 = require("../include/usermanagement.class");
const Reseller_1 = require("../include/Reseller");
const Commission_1 = require("../include/Commission");
var multer = require('multer');
const extractImage = require("../include/multerImage");
var upload = multer({ dest: process.cwd() + "/uploads/" });
exports.type = upload.single('filename');
module.exports = function (app) {
    var tier = new tiermanagement_class_1.TierManagement();
    app.get("/getTariffs", tier.getTraiffs);
    app.get("/getTariff", tier.getTraiff);
    app.get("/unregisteredrates", tier.voiceApiRates);
    app.get("/CampaignReviewRates", tier.CampaignReviewRates);
    app.get("/brandReviewRates", tier.BrandReviewRates);
    app.get("/getactivate_msg", tier.get_activatemsg);
    app.get("/lookupRates", tier.lookupRates);
    // Get Registered Rates
    app.get("/usa_sms_rates", tier.GetUSA_SMS_Rates);
    var user = new usermanagement_class_1.UserManagement();
    /**
     * To authenticate user with TimeZone
     */
    app.post("/login", user.getLogin);
    app.post("/update_sys_tz", user.SaveSysTZ);
    app.put("/custom/changepassword/", user.ChangePassword);
    app.put("/custom/changepass/", user.ChangePassword);
    app.get("/user", user.UserList);
    app.get("/singleuser", user.singleUser);
    app.post("/uploads/document_upload", exports.type, user.UploadDocuments);
    app.post("/tax_calculation", user.TaxCalculation);
    app.post("/add_billing_address", user.addBillingAddress);
    app.post("/get_geo_code", user.getGeoCode);
    app.get("/get_billing_address", user.getBillingAddress);
    app.put("/update_billing_address", user.updateBillingAddress);
    app.post("/saveTheme", user.saveTheme);
    app.put("/updatetheme", extractImage, user.updateTheme);
    app.get("/theme", user.getTheme);
    app.get("/themes", user.getThemes);
    //Link Generation for reseller Customer
    app.post("/linkGeneration", user.linkGeneration);
    app.get("/getLink", user.getLink);
    app.get("/getsingleLink", user.getsingleLink);
    app.put("/updateLink", user.updatelink);
    app.delete("/deleteURL", user.deleteURL);
    //forgot password start
    app.put("/update-password", user.updatePassword);
    app.post("/forgot-mail", user.sendMailForForgetPass);
    app.get("/verify-token", user.VerifyToken);
    //forgot password end
    app.get("/company", user.getCompanyProfile);
    app.put("/update-tariff", user.updateTariff);
    app.put("/profile-pic", extractImage, user.updateProfilePic);
    app.put("/removeProfile-pic", extractImage, user.removeProfilePic);
    app.put("/uploadFile", extractImage, user.uploadFile);
    app.post("/sendFile", extractImage, user.sendFile);
    app.get("/getFile", user.getFile);
    // Resend Email
    app.post("/resendemail", user.resendEmail);
    // otp
    app.post("/saveotp", user.saveOtp);
    app.post("/verifyOtp", user.verifyOtp);
    /**
     * Other Routes
     */
    app.get("/get_timezones", user.GetTimeZones);
    app.get("/get_user_timezone", user.GetUserTimeZone);
    app.post("/user_timezone", user.UpdateUserTimeZone);
    // Morphing Session 
    app.get("/morphing-session", user.getMorphingSession);
    app.get("/getUrlTariff", user.getUrlTariff);
    app.put("/updateOrdering", user.updateOrdering);
    app.put("/update-organization", user.updateOrganization);
    const reseller = new Reseller_1.Reseller();
    app.put("/updateResellerbyID", reseller.updateResellerbyID);
    app.get("/commissionTerm", reseller.commissionTerm);
    const commission = new Commission_1.Commission();
    app.get("/getCommissionPlan", commission.getCommissionPlan);
    app.get("/getCommissionTier", commission.getCommissionTier);
    app.get("/commissionDetailsFilter", commission.commissionFilter);
    app.get("/commSummaryFilter", commission.commSummaryFilter);
    var obj = new AppRoute_1.AppRoute();
    app.get("/[a-z]{1,20}/[a-z]{1,20}", obj.getMethod);
    app.get("/[a-z]{1,20}", obj.getMethod);
    app.post("/[a-z]{1,20}", obj.postMethod);
    app.put("/[a-z]{1,20}", obj.putMethod);
    app.delete("/[a-z]{1,20}", obj.deleteMethod);
    app.patch("/[a-z]{1,20}", obj.patchMethod);
};
