/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { CredentialListList } from './trunk/credentialList';
import { CredentialListListInstance } from './trunk/credentialList';
import { IpAccessControlListList } from './trunk/ipAccessControlList';
import { IpAccessControlListListInstance } from './trunk/ipAccessControlList';
import { OriginationUrlList } from './trunk/originationUrl';
import { OriginationUrlListInstance } from './trunk/originationUrl';
import { PhoneNumberList } from './trunk/phoneNumber';
import { PhoneNumberListInstance } from './trunk/phoneNumber';
import { RecordingList } from './trunk/recording';
import { RecordingListInstance } from './trunk/recording';
import { SerializableClass } from '../../../interfaces';

type TrunkTransferSetting = 'disable-all'|'enable-all'|'sip-only';

/**
 * Initialize the TrunkList
 *
 * @param version - Version of the resource
 */
declare function TrunkList(version: V1): TrunkListInstance;

/**
 * Options to pass to update
 *
 * @property cnamLookupEnabled - Whether Caller ID Name (CNAM) lookup should be enabled for the trunk
 * @property disasterRecoveryMethod - The HTTP method we should use to call the disaster_recovery_url
 * @property disasterRecoveryUrl - The HTTP URL that we should call if an error occurs while sending SIP traffic towards your configured Origination URL
 * @property domainName - The unique address you reserve on Twilio to which you route your SIP traffic
 * @property friendlyName - A string to describe the resource
 * @property secure - Whether Secure Trunking is enabled for the trunk
 * @property transferMode - The call transfer settings for the trunk
 */
interface TrunkInstanceUpdateOptions {
  cnamLookupEnabled?: boolean;
  disasterRecoveryMethod?: string;
  disasterRecoveryUrl?: string;
  domainName?: string;
  friendlyName?: string;
  secure?: boolean;
  transferMode?: TrunkTransferSetting;
}

interface TrunkListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrunkContext;
  /**
   * create a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * create a TrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: TrunkListInstanceCreateOptions, callback?: (error: Error | null, item: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * Streams TrunkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TrunkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TrunkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TrunkListInstanceEachOptions, callback?: (item: TrunkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a trunk
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): TrunkContext;
  /**
   * Retrieve a single target page of TrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TrunkPage) => any): Promise<TrunkPage>;
  /**
   * Retrieve a single target page of TrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TrunkPage) => any): Promise<TrunkPage>;
  /**
   * Lists TrunkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TrunkInstance[]) => any): Promise<TrunkInstance[]>;
  /**
   * Lists TrunkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TrunkListInstanceOptions, callback?: (error: Error | null, items: TrunkInstance[]) => any): Promise<TrunkInstance[]>;
  /**
   * Retrieve a single page of TrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TrunkPage) => any): Promise<TrunkPage>;
  /**
   * Retrieve a single page of TrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TrunkListInstancePageOptions, callback?: (error: Error | null, items: TrunkPage) => any): Promise<TrunkPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property cnamLookupEnabled - Whether Caller ID Name (CNAM) lookup should be enabled for the trunk
 * @property disasterRecoveryMethod - The HTTP method we should use to call the disaster_recovery_url
 * @property disasterRecoveryUrl - The HTTP URL that we should call if an error occurs while sending SIP traffic towards your configured Origination URL
 * @property domainName - The unique address you reserve on Twilio to which you route your SIP traffic
 * @property friendlyName - A string to describe the resource
 * @property secure - Whether Secure Trunking is enabled for the trunk
 * @property transferMode - The call transfer settings for the trunk
 */
interface TrunkListInstanceCreateOptions {
  cnamLookupEnabled?: boolean;
  disasterRecoveryMethod?: string;
  disasterRecoveryUrl?: string;
  domainName?: string;
  friendlyName?: string;
  secure?: boolean;
  transferMode?: TrunkTransferSetting;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TrunkListInstanceEachOptions {
  callback?: (item: TrunkInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TrunkListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TrunkListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TrunkPayload extends TrunkResource, Page.TwilioResponsePayload {
}

interface TrunkResource {
  account_sid: string;
  auth_type: string;
  auth_type_set: string[];
  cnam_lookup_enabled: boolean;
  date_created: Date;
  date_updated: Date;
  disaster_recovery_method: string;
  disaster_recovery_url: string;
  domain_name: string;
  friendly_name: string;
  links: string;
  recording: object;
  secure: boolean;
  sid: string;
  transfer_mode: TrunkTransferSetting;
  url: string;
}

interface TrunkSolution {
}


declare class TrunkContext {
  /**
   * Initialize the TrunkContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, sid: string);

  credentialsLists: CredentialListListInstance;
  /**
   * fetch a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  ipAccessControlLists: IpAccessControlListListInstance;
  originationUrls: OriginationUrlListInstance;
  phoneNumbers: PhoneNumberListInstance;
  recordings: RecordingListInstance;
  /**
   * remove a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * update a TrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrunkInstanceUpdateOptions, callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
}


declare class TrunkInstance extends SerializableClass {
  /**
   * Initialize the TrunkContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: TrunkPayload, sid: string);

  private _proxy: TrunkContext;
  accountSid: string;
  authType: string;
  authTypeSet: string[];
  cnamLookupEnabled: boolean;
  /**
   * Access the credentialsLists
   */
  credentialsLists(): CredentialListListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  disasterRecoveryMethod: string;
  disasterRecoveryUrl: string;
  domainName: string;
  /**
   * fetch a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  friendlyName: string;
  /**
   * Access the ipAccessControlLists
   */
  ipAccessControlLists(): IpAccessControlListListInstance;
  links: string;
  /**
   * Access the originationUrls
   */
  originationUrls(): OriginationUrlListInstance;
  /**
   * Access the phoneNumbers
   */
  phoneNumbers(): PhoneNumberListInstance;
  recording: any;
  /**
   * Access the recordings
   */
  recordings(): RecordingListInstance;
  /**
   * remove a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<boolean>;
  secure: boolean;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  transferMode: TrunkTransferSetting;
  /**
   * update a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * update a TrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrunkInstanceUpdateOptions, callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  url: string;
}


declare class TrunkPage extends Page<V1, TrunkPayload, TrunkResource, TrunkInstance> {
  /**
   * Initialize the TrunkPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TrunkSolution);

  /**
   * Build an instance of TrunkInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrunkPayload): TrunkInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrunkContext, TrunkInstance, TrunkInstanceUpdateOptions, TrunkList, TrunkListInstance, TrunkListInstanceCreateOptions, TrunkListInstanceEachOptions, TrunkListInstanceOptions, TrunkListInstancePageOptions, TrunkPage, TrunkPayload, TrunkResource, TrunkSolution, TrunkTransferSetting }
