"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DebounceInput = void 0;

var _react = _interopRequireDefault(require("react"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DebounceInput = /*#__PURE__*/function (_React$PureComponent) {
  _inherits(DebounceInput, _React$PureComponent);

  var _super = _createSuper(DebounceInput);

  function DebounceInput(props) {
    var _this;

    _classCallCheck(this, DebounceInput);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "onChange", function (event) {
      event.persist();
      var oldValue = _this.state.value;
      var minLength = _this.props.minLength;

      _this.setState({
        value: event.target.value
      }, function () {
        var value = _this.state.value;

        if (value.length >= minLength) {
          _this.notify(event);

          return;
        } // If user hits backspace and goes below minLength consider it cleaning the value


        if (oldValue.length > value.length) {
          _this.notify(_objectSpread(_objectSpread({}, event), {}, {
            target: _objectSpread(_objectSpread({}, event.target), {}, {
              value: ''
            })
          }));
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      if (event.key === 'Enter') {
        _this.forceNotify(event);
      } // Invoke original onKeyDown if present


      var onKeyDown = _this.props.onKeyDown;

      if (onKeyDown) {
        event.persist();
        onKeyDown(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function (event) {
      _this.forceNotify(event); // Invoke original onBlur if present


      var onBlur = _this.props.onBlur;

      if (onBlur) {
        event.persist();
        onBlur(event);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "createNotifier", function (debounceTimeout) {
      if (debounceTimeout < 0) {
        _this.notify = function () {
          return null;
        };
      } else if (debounceTimeout === 0) {
        _this.notify = _this.doNotify;
      } else {
        var debouncedChangeFunc = (0, _lodash["default"])(function (event) {
          _this.isDebouncing = false;

          _this.doNotify(event);
        }, debounceTimeout);

        _this.notify = function (event) {
          _this.isDebouncing = true;
          debouncedChangeFunc(event);
        };

        _this.flush = function () {
          return debouncedChangeFunc.flush();
        };

        _this.cancel = function () {
          _this.isDebouncing = false;
          debouncedChangeFunc.cancel();
        };
      }
    });

    _defineProperty(_assertThisInitialized(_this), "doNotify", function () {
      var onChange = _this.props.onChange;
      onChange.apply(void 0, arguments);
    });

    _defineProperty(_assertThisInitialized(_this), "forceNotify", function (event) {
      var debounceTimeout = _this.props.debounceTimeout;

      if (!_this.isDebouncing && debounceTimeout > 0) {
        return;
      }

      if (_this.cancel) {
        _this.cancel();
      }

      var value = _this.state.value;
      var minLength = _this.props.minLength;

      if (value.length >= minLength) {
        _this.doNotify(event);
      } else {
        _this.doNotify(_objectSpread(_objectSpread({}, event), {}, {
          target: _objectSpread(_objectSpread({}, event.target), {}, {
            value: value
          })
        }));
      }
    });

    _this.isDebouncing = false;
    _this.state = {
      value: typeof props.value === 'undefined' || props.value === null ? '' : props.value
    };
    var _debounceTimeout2 = _this.props.debounceTimeout;

    _this.createNotifier(_debounceTimeout2);

    return _this;
  }

  _createClass(DebounceInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.isDebouncing) {
        return;
      }

      var _this$props = this.props,
          value = _this$props.value,
          debounceTimeout = _this$props.debounceTimeout;
      var oldTimeout = prevProps.debounceTimeout,
          oldValue = prevProps.value;
      var stateValue = this.state.value;

      if (typeof value !== 'undefined' && oldValue !== value && stateValue !== value) {
        // Update state.value if new value passed via props, yep re-render should happen
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          value: value
        });
      }

      if (debounceTimeout !== oldTimeout) {
        this.createNotifier(debounceTimeout);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.flush) {
        this.flush();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          element = _this$props2.element,
          _onChange = _this$props2.onChange,
          _value = _this$props2.value,
          _minLength = _this$props2.minLength,
          _debounceTimeout = _this$props2.debounceTimeout,
          forceNotifyByEnter = _this$props2.forceNotifyByEnter,
          forceNotifyOnBlur = _this$props2.forceNotifyOnBlur,
          onKeyDown = _this$props2.onKeyDown,
          onBlur = _this$props2.onBlur,
          inputRef = _this$props2.inputRef,
          props = _objectWithoutProperties(_this$props2, ["element", "onChange", "value", "minLength", "debounceTimeout", "forceNotifyByEnter", "forceNotifyOnBlur", "onKeyDown", "onBlur", "inputRef"]);

      var value = this.state.value;
      var maybeOnKeyDown;

      if (forceNotifyByEnter) {
        maybeOnKeyDown = {
          onKeyDown: this.onKeyDown
        };
      } else if (onKeyDown) {
        maybeOnKeyDown = {
          onKeyDown: onKeyDown
        };
      } else {
        maybeOnKeyDown = {};
      }

      var maybeOnBlur;

      if (forceNotifyOnBlur) {
        maybeOnBlur = {
          onBlur: this.onBlur
        };
      } else if (onBlur) {
        maybeOnBlur = {
          onBlur: onBlur
        };
      } else {
        maybeOnBlur = {};
      }

      var maybeRef = inputRef ? {
        ref: inputRef
      } : {};
      return /*#__PURE__*/_react["default"].createElement(element, _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, props), {}, {
        onChange: this.onChange,
        value: value
      }, maybeOnKeyDown), maybeOnBlur), maybeRef));
    }
  }]);

  return DebounceInput;
}(_react["default"].PureComponent);

exports.DebounceInput = DebounceInput;

_defineProperty(DebounceInput, "defaultProps", {
  element: 'input',
  type: 'text',
  onKeyDown: undefined,
  onBlur: undefined,
  value: undefined,
  minLength: 0,
  debounceTimeout: 100,
  forceNotifyByEnter: true,
  forceNotifyOnBlur: true,
  inputRef: undefined
});