import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';

@Injectable({
  providedIn: 'root'
})

export class AgentserviceService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http)
   }

   @LoaderEnabled()
   getSingleAgent(id: any): Observable <any> {
    this.appmod = "getsingleagent";
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getAccSettingStatus(): Observable <any> {
   this.appmod = "getAccSettingStatus";
   let result = super.getService();
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 channelRequest(data: any): Observable<any> {
   this.appmod = 'channel-request';
   let result = super.saveService(data);
   this.appmod = "";
   return result;
 }
 
 @LoaderEnabled()
 getRequestChannelList(data?: any): Observable<any> {
   this.appmod = "channel-request-list";
   let tmp = this.getService(data);
   this.appmod = "";
   return tmp;
 }

 @LoaderEnabled()
 channelLimitStatus(data: any) {
   this.appmod = "approve-and-reject-channel-limit";
   let result = super.updateService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
  getSingleGroup(id: any): Observable <any> {
    this.appmod = "getsinglegroup";
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
   getAgents(groupKey?: any): Observable<any> {
    let apiURL = environment.SERVER+ "getagents";
    return this.http.get(apiURL, { headers: this.httpHeaders, params: {groupKey: groupKey}});
   }

   @LoaderEnabled()
  saveAgent(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "addagent";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  updateAgent(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "updateagent";
    return this.http.patch(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  deleteAgent(id: any): Observable <any> {
    this.appmod = "deleteagent";
    let result = super.deleteService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  saveGroup(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "addgroup";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  updateGroup(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "updategroup";
    return this.http.patch(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  getGroups(): Observable<any> {
    let apiURL = environment.SERVER+ "getgroup";
    return this.http.get(apiURL, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  deleteGroup(id: any): Observable <any> {
    this.appmod = "deletegroup";
    let result = super.deleteService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  saveMapping(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "addtiermapping";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  getTierMapping(id: any): Observable<any> {
    this.appmod = "getmapping";
    let result = this.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateMapping(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "updatemapping";
    return this.http.put(apiURL, data, { headers: this.httpHeaders });
  }


  get_agent():Observable<any>{
    return this.http.get('./assets/agentdetails.json')
  }

  get_group():Observable<any>{
    return this.http.get('./assets/groupdetails.json')
  }



}
