import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ApiService } from '../api.service';
import { TokensComponent } from '../tokens/tokens.component';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

@Component({
  selector: 'app-addtoken',
  templateUrl: './addtoken.component.html',
  styleUrls: ['./addtoken.component.css']
})
export class AddtokenComponent implements OnInit {
  tokenForm: FormGroup;
  public submitted: boolean = false;
  responseMessage = "";
  dangMessage = "";
  errMessage = "";
  users: any;
  userType: number;
  session: any;
  dropdownSettings: IDropdownSettings = {};
  usersnames: any = [];
  userlist: any = [];
  dropdownSetting: IDropdownSettings = {};
  closeDropdownSelection = true;
  userdata: any = [];
  constructor(private data: ApiService, public fb: FormBuilder, public dialog: MatDialogRef<TokensComponent>) { }

  ngOnInit() {

    let session$ = sessionStorage.getItem("isLoggedIn");
    this.session = JSON.parse(session$);
    this.userType = this.session.type;

    this.data.subCustomers().subscribe((result: any) => {
      this.users = result.data;
      // this.usersnames = this.users.map((user: any) => {
      //   return { id: user.iduser, username: user.username }; 
      // });
      // console.log("Usernames array:", this.users);

      // -----------------------new code change----------------------------------
      this.userdata = result.data.map(item => ({
        iduser: item.iduser,
        userdata: `${item.customer_name}`
      }));

      if (this.session.iduser) {
        const preSelectedUser = this.userdata.find(user => user.iduser === this.session.iduser);
        if (preSelectedUser) {
          this.tokenForm.patchValue({
            user: [preSelectedUser]
          });
        }
      }
    }, err => {
      console.log(err.message);
    });

    this.tokenForm = this.fb.group({
      name: ['', [Validators.required, Validators.maxLength(255)]],
      account: [''],
      user: ['', [Validators.required]],
      idtariff: [''],
      status: ['']
    });

    this.tokenForm.patchValue({
      account: this.session.idaccount,
      user: this.session.iduser,
      idtariff: this.session.idtariff,
      status: this.session.status
    });

    this.dropdownSetting = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'userdata',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.tokenForm.get('user').valueChanges.subscribe((value) => {
      if (!value || value.length === 0) {
        this.tokenForm.get('user').setErrors({ required: true });
        this.tokenForm.get('user').markAsTouched();
        this.tokenForm.get('user').markAsDirty();
      }
    });
  }

  onTokenSave() {

    this.submitted = true;
    if (this.tokenForm.value.user == '' && this.userType == 2) {
      return false;
    }
    else {
      if (this.tokenForm.invalid) {
        return;
      }
      else {
        this.tokenForm.value.user = this.tokenForm.value.user[0].iduser
        this.data.saveToken(this.tokenForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.dialog.close(res.message);
          }
          else {
            this.dangMessage = res.message;
            setTimeout(() => {
              this.dangMessage = "";
            }, 5000);
          }
        }, err => {
          this.dangMessage = 'Connection Lost!';
          setTimeout(() => {
            this.dangMessage = "";
          }, 5000);
        });
      }
    }
  }

  onSelectUser(e) {
    let iduser = e.target.value;
    let selectedUser = this.users.find(x => x.iduser == iduser);
    this.tokenForm.patchValue({
      user: selectedUser.iduser,
      idtariff: selectedUser.idtariff,
      status: selectedUser.status,
      account: selectedUser.idaccount,
    });
  }

  onReset() {
    this.submitted = false;
    if (this.userType == 2) {
      this.tokenForm.get('user').setValue('');
      this.tokenForm.get('name').setValue('');
      this.tokenForm.get('user').markAsUntouched();
      this.tokenForm.get('name').markAsUntouched();
      this.tokenForm.get('user').markAsPristine();
      this.tokenForm.get('name').markAsPristine();
    }
    else {
      this.tokenForm.reset({
        account: this.session.idaccount,
        user: this.session.iduser,
        idtariff: this.session.idtariff,
        status: this.session.status
      });
    }
  }

}
