import { FormBuilder, FormGroup, Validators } from "@angular/forms";

export interface token
{
    name:string,
    endpoint:string,
    did:string,
    supplier:string,
    customer:string,
    sms:string,
    voice:string,

    billing:string,
    invoice:string,
    api:string,
    agent:string,
    queue:string,
    rates:string,
    routing:string,
    preference:string
}

export interface HTTPtoken
{
   name:string,
   endpoint:string,
   did:string,
   supplier:string,
   customer:string,
   sms:string,
   voice:string,
   billing:string,
    invoice:string,
    api:string,
    agent:string,
    queue:string,
    rates:string,
    routing:string,
    preference:string   
}

export class tokenForm implements HTTPtoken
{
   public name:string;
   public endpoint:string;
   public did:string;
   public supplier:string;
   public customer:string;
   public sms:string;
   public voice:string;
   public  billing:string;
   public  invoice:string;
   public  api:string;
   public  agent:string;
   public  queue:string;
   public rates:string;
   public routing:string;
   public preference:string
  
    constructor(data : token) 
    {
        if(data==null)
        {        
           this.name="";
           this.endpoint="";
           this.did="";
           this.supplier="";
           this.customer="";
           this.sms="";
           this.voice="";
           this.billing="";
           this.invoice="";
           this.api="";
           this.agent="";
           this.queue="";
           this.rates="";
           this.routing="";
           this.preference="";
        }
        else
        {         
            this.name = data.name;
            this.endpoint = data.endpoint;
            this.did = data.did;
            this.supplier = data.supplier;
            this.customer = data.customer;
            this.sms = data.sms;
            this.voice = data.voice;

            this.billing = data.billing;
            this.invoice = data.invoice;
            this.api = data.api;
            this.agent = data.agent;
            this.queue = data.queue;
            this.rates = data.rates;
            this.routing = data.routing;
            this.preference = data.preference;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            name:[this.name],
            endpoint:[this.endpoint],
            did:[this.did],
            supplier:[this.supplier],
            customer:[this.customer],
            sms:[this.sms],
            voice:[this.voice],

            billing:[this.billing],
            invoice:[this.invoice],
            api:[this.api],
            agent:[this.agent],
            queue:[this.queue],
            rates:[this.rates],
            routing:[this.routing],
            preference:[this.preference]
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.name=  fg.get("name").value;
            this.endpoint=  fg.get("endpoint").value;
            this.did=  fg.get("did").value;
            this.supplier=  fg.get("supplier").value;
            this.customer=  fg.get("customer").value;
            this.sms=  fg.get("sms").value;
            this.voice=  fg.get("voice").value;

            this.billing =  fg.get("billing").value;
            this.invoice =  fg.get("invoice").value;
            this.api =  fg.get("api").value;
            this.agent =  fg.get("agent").value;
            this.queue =  fg.get("queue").value;
            this.rates =  fg.get("rates").value;
            this.routing=  fg.get("routing").value;
            this.preference =  fg.get("preference").value;


            return true;
        }
        else
        {
            return false;
        }
    }
  }
