import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';

@Injectable({
  providedIn: 'root'
})
export class ApiService extends AppService<any>{

  constructor(public http: HttpClient) {
    super(http)
   }

   @LoaderEnabled()
   getApiToken(): Observable<any> {
     this.appmod = "apiToken";
     let result = this.getService();
     this.appmod = "";
     return result;
   }

  
   @LoaderEnabled()
  saveToken(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'apiToken';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  onDeleteApiToken(id): Observable<any>{
    this.appmod = "apiToken";
    let result = this.deleteService(id);
    this.appmod = "";
    return result;
  }

  // @LoaderEnabled()
  subCustomers(): Observable<any>{
    this.appmod = "subcustomers";
    let result = this.getService();
    this.appmod = "";
    return result;
  }

  get_apitoken():Observable<any>{
    return this.http.get('./assets/api_token.json')
  }
}
