import { Component } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { ApiService } from '../api.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AddtokenComponent } from '../addtoken/addtoken.component';
import { Router } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
declare var $: any;

@Component({
  selector: 'app-tokens',
  templateUrl: './tokens.component.html',
  styleUrls: ['./tokens.component.css']
})

export class TokensComponent extends AppComponentClass<any, any>{
  filterMetadata = { count: 0 };
  filtre: string;
  searchText = { count: 0 };
  pShow = false;

  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  filterTerm: string;
  responseMessage = "";
  msgHideAndShow: boolean = false;
  resData: any = [];
  password: any;
  userType: number;
  session: any;

  constructor(public data: ApiService, public dialog: MatDialog, public router: Router, public fb: FormBuilder) {
    super(data, router, fb);
  }

  ngOnInit() {

    let session$ = sessionStorage.getItem("isLoggedIn");
    this.session = JSON.parse(session$);
    this.userType = this.session.type;
    this.password = "password";

    // const table: any = $('#basic-datatables');

    this.data.getApiToken().subscribe(res => {
      this.resData = res.data;
      $('#basic-datatabless06').DataTable().destroy();
      $.getScript('./assets/table.js');
      this.resData.forEach(element => {
        element.pShow = false;
        element.pswd = "password";
      });
    });
  }

  keyToggle(id) {
    this.resData.forEach(element => {
      if (element.idapi == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  }


  openDialog() {
    const dialogRef = this.dialog.open(AddtokenComponent, {
      disableClose: true,
    });

    dialogRef.afterClosed().subscribe(result => {
      this.responseMessage = result;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
      this.ngOnInit();
    });
  }

  onApiDelete(id,key) {
    if (confirm("Are you sure you want delete data!")) {
      this.data.onDeleteApiToken(id+"@"+key).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.data.getApiToken().subscribe(res => {
          this.resData = res.data;
          $('#basic-datatabless06').DataTable().destroy();
          $.getScript('./assets/table.js');
          this.resData.forEach(element => {
            element.pShow = false;
            element.pswd = "password";
          });
        });
      });
    } else {
      "Cancel!"
    }
  }

  textMessageFunc(msgText) {
    this.responseMessage = "Copied to Clipboard";
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  }


  applyFilter(event: Event) {
    const filterValue = (event.target as HTMLInputElement).value;
    this.dataSource.filter = filterValue.trim().toLowerCase();

    if (this.dataSource.paginator) {
      this.dataSource.paginator.firstPage();
    }
  }
  toggleDescription(data, property) {
    data[property] = !data[property];
  }
}


