import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { Approutes } from './app-routing.module';
import { AppComponent } from './app.component';
import { CommonModule, HashLocationStrategy, LocationStrategy } from '@angular/common';
import { FormsModule } from '@angular/forms';
import { HttpClientModule, HTTP_INTERCEPTORS } from '@angular/common/http';
import { RouterModule } from '@angular/router';
import { BlankComponent } from './layouts/blank/blank.component';
import { FullComponent } from './layouts/full/full.component';
import { SharedModule } from './shared/shared.module';
import { NotificationModule } from './shared/notification/notification.module'
import { JwtInterceptor } from './authentication/helper/jwt.interceptor';
import { HttpErrorInterceptor } from './authentication/helper/error.interceptor';
import { AuthGuard } from './authentication/guard/auth.guard';
import { AuthenticationService } from './authentication/authentication.service';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { DemoMaterialModule } from './demo-material-module';
import { NgApexchartsModule } from 'ng-apexcharts';
import { StoreModule } from '@ngrx/store';
import { inboundReducer } from './inbound/inbound.reducer';
import {MatTableModule} from '@angular/material/table';
import { ToastrModule } from 'ngx-toastr';

// import { reducers } from './reducer';

@NgModule({
  declarations: [
    AppComponent,
    FullComponent,
    BlankComponent,
  ],
  imports: [
    CommonModule,
    BrowserModule,
    FormsModule,
    HttpClientModule,
    SharedModule,
    RouterModule,
    MatTableModule,
    NgbModule,
    NotificationModule,
    BrowserAnimationsModule,
    RouterModule.forRoot(Approutes),
    FontAwesomeModule,
    DemoMaterialModule,
    MatSnackBarModule,
    NgApexchartsModule,
    // StoreModule.forRoot({})
    StoreModule.forRoot({inbound: inboundReducer}),
    ToastrModule.forRoot()
  ],
  providers: [
    { provide: LocationStrategy, useClass: HashLocationStrategy },
    { provide: HTTP_INTERCEPTORS, useClass: JwtInterceptor, multi: true },
    { provide: HTTP_INTERCEPTORS, useClass: HttpErrorInterceptor, multi: true },

    // provider used to create fake backend
   AuthenticationService, AuthGuard,
  ],
  bootstrap: [AppComponent]
})
export class AppModule {
  constructor(){
  }
 }
