import { LocationStrategy } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { AuthenticationService } from '../authentication.service';
@Component({
  selector: 'app-delete-user',
  templateUrl: './delete-user.component.html',
  styleUrls: ['./delete-user.component.css']
})
export class DeleteUserComponent implements OnInit {
  routeSub: any;
  id: any;
  responseMessage = "";
  errMessage = "";
  data1: any;
  isDeleted: any = '2';
  checkdelete: boolean = false;
  returnsms: boolean = false;
  sesiduser: any;
  stepper: any;
  Location: any;
  userdata: any;
  btnName:any = "Delete My Account";
  
  constructor(private location: LocationStrategy, private activatedRoute: ActivatedRoute, public router: Router, public data: UsermanagementService, protected authService: AuthenticationService) {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    if (!this.sesiduser.iduser) {
      this.router.navigateByUrl('/login');
    }
  }

  ngOnInit(): void {
    this.btnName="Delete My Account";
    history.pushState(null, null, window.location.href);
    // check if back or forward button is pressed.
    this.Location.onPopState(() => {
      history.pushState(null, null, window.location.href);
      this.stepper.previous();
    });
  }
  onDelAccount() {
    //this.btnName="InProcess...";
    this.data.getSingleUsers().subscribe(res => {
      if (res.status == 200) {
       // this.btnName="InProcess...";
        this.userdata = res.data1[0];

        if((this.userdata.isEmailVerify == 'true' && this.userdata.isMobileVerify == 'true') && (this.userdata.isAddress == 'true' && this.userdata.isPlan == 'true'))
        {
          this.isDeleted=1; // onboarding completed
        }
        else{
          this.isDeleted=2; // onboarding not completed
        }
        this.data1 = {
          sesiduser: this.sesiduser.iduser,
          sesidaccount: this.sesiduser.idaccount,
          isDeleted: this.isDeleted
        }
        if (!this.data1.sesiduser || !this.data1.isDeleted) {
          return;
        }
        else {
          this.btnName="InProcess...";
          this.data.onDeleteAccount(this.data1).subscribe((res) => {
            if (res.status == 201) {
              //this.btnName="Delete My Account";
              this.responseMessage = res.message
              setTimeout(() => {
                this.responseMessage = "";
              }, 3000);
              setTimeout(() => {
                localStorage.clear();
                sessionStorage.clear();
                this.router.navigate(['/restore-account']);
              }, 5000);
            }
            else{
              this.btnName="Delete My Account";
              this.errMessage = res.message
              setTimeout(() => {
                this.errMessage = "";
              },4000);
            }
          });
        }
      }
    });
  }

	}
