import { Injectable } from '@angular/core';
import { HttpRequest, HttpHandler, HttpEvent, HttpInterceptor, HttpErrorResponse } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { Router } from '@angular/router';


@Injectable()
export class HttpErrorInterceptor implements HttpInterceptor {
    constructor(protected router: Router) { }

    intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
        return next.handle(request).pipe(catchError((error: HttpErrorResponse) => {

            // If there is an invalid session or session doesn't exist
            if (error.status == 406) {
                let errorMessage = error.error.message
                localStorage.clear()
                sessionStorage.clear()
                sessionStorage.setItem("errMsg", errorMessage)
                this.router.navigate(['/login'])
            }

            return throwError(error);
        }));
    }
}