
export interface Authentication
{
    agent_id: number,
    agent_name: string,
    agent_group_id: number,
    agent_number: string,
    admin_access: number,
    agent_rank: number,
    extenstion: string,
    is_status: number,
    company_id: number,
    agent_priority: number,
    group_name?: string,
    usertype: number  
}

export interface HTTPAuthentication
{
    agent_id:number,
    agent_name: string,
    agent_group_id:number,
    agent_number:string,
    admin_access:number,
    agent_rank: number,
    extenstion: string,
    is_status: number,
    company_id:number,
    agent_priority:number,
    group_name?:string,
    usertype:number
}

export class AuthenticationForm implements HTTPAuthentication{
    public agent_id:number;
    public agent_name: string;
    public agent_group_id:number;
    public agent_number:string;
    public admin_access:number;
    public agent_rank: number;
    public extenstion: string;
    public is_status: number;
    public company_id:number;
    public agent_priority:number;
    public group_name?:string;
    public usertype: number;
    
    constructor(data : Authentication) 
    {
        if(data==null)
        {
            this.agent_id=0;
            this.agent_group_id=0;
            this.agent_name="";
            this.company_id=0;
            this.agent_number="";
            this.agent_priority=-1;
            this.agent_rank=-1;
            this.extenstion="";
            this.is_status=-1;
            this.admin_access=-1;
            this.group_name="";
            this.usertype=-1;
        }
        else
        {
            this.agent_id=data.agent_id;
            this.agent_group_id=data.agent_group_id;
            this.agent_name=data.agent_name;
            this.company_id=data.company_id;
            this.agent_number=data.agent_number;
            this.agent_priority=data.agent_priority;
            this.agent_rank=data.agent_rank;
            this.extenstion=data.extenstion;
            this.is_status=data.is_status;
            this.admin_access=data.admin_access;
            this.group_name=data.group_name;
            this.usertype=data.usertype;
        }
    }
  }
