import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AuthenticationService } from '../authentication.service';

@Component({
  selector: 'app-setpassword',
  templateUrl: './setpassword.component.html',
  styleUrls: ['./setpassword.component.css']
})
export class SetpasswordComponent implements OnInit {
  eyetoggle: boolean = false;
  eyetoggle1: boolean = false;
  eyetoggle2: boolean = false;
  setpasswordForm: FormGroup;
  submitted: boolean= false;
  errMessage: any = "";
  responseMessage = "";
  constructor(protected data: AuthenticationService,protected router: Router,public fb: FormBuilder,private activatedroute: ActivatedRoute) { }
   ngOnInit(): void {


    this.setpasswordForm = this.fb.group({
      key: [''],
      password: ['', [Validators.required,Validators.minLength(8)]],
      cnfpassword: ['', [Validators.required,Validators.minLength(8)]]
    });

    this.activatedroute.paramMap.subscribe((params: ParamMap) => {
      let id = params.get('id');
      this.setpasswordForm.patchValue({
        key: id,
      });
      console.log(id);
    })

  }


  eyeToggle(check: any) {
    if (check == 1)
      if (this.eyetoggle)
        this.eyetoggle = false
      else
        this.eyetoggle = true
    else if (check == 2)
      if (this.eyetoggle1)
        this.eyetoggle1 = false
      else
        this.eyetoggle1 = true
    else
      if (this.eyetoggle2)
        this.eyetoggle2 = false
      else
        this.eyetoggle2 = true
  }

  onSubmit(){
    this.submitted = true;
    if ( this.setpasswordForm.controls.password.invalid || this.setpasswordForm.controls.cnfpassword.invalid){
      return;
    }else{
      if(this.setpasswordForm.value.password === this.setpasswordForm.value.cnfpassword){
        this.data.setPassword(this.setpasswordForm.value).subscribe(res=>{
          if(res.status == 201){ 
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigate(['/']).then(() => {
                location.reload();
              });                
          }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
                this.errMessage = "";
            }, 5000);
          }
        })
      }else{
        this.errMessage = "Password and Confirm-Password Does Not Match!";
        setTimeout(() => {
            this.errMessage = "";
        }, 5000);
      }
    }
    
  }
  reset(){
    this.submitted = false;
    this.setpasswordForm.get('password').reset();
    this.setpasswordForm.get('cnfpassword').reset();
  }
}
