import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { timer } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

@Component({
  selector: 'app-userlogin',
  templateUrl: './userlogin.component.html',
  styleUrls: ['./userlogin.component.css']
})
export class UserloginComponent implements OnInit {
  errMessage: any;
  kyc_status: any;
  countdown: number = Math.floor(Math.random() * 4) + 5;

  constructor(private router: Router, private activatedRoute: ActivatedRoute, private data: UsermanagementService) { }

  ngOnInit(): void {
    this.activatedRoute.paramMap.subscribe((param: ParamMap) => {
      let auth = param.get("auth");

      // let interval = setInterval(() => {
      //   this.countdown--;
      //   if (this.countdown <= 0) {
      //     clearInterval(interval);
      if (auth) {
        this.data.morphingSession(auth).subscribe(res => {
          if (res.status == 200) {
            let userData = res.data[0];
            this.data.getSingleUsersForAdmin(userData.iduser).subscribe(res => {
              this.kyc_status = res.data1[0].kyc_verify_status;
              sessionStorage.clear();
              sessionStorage.setItem('isLoggedIn', JSON.stringify(userData));
              sessionStorage.setItem('authkey', userData.authkey);
              sessionStorage.setItem('type', userData.type);
              sessionStorage.setItem('iduser', userData.iduser);
              sessionStorage.setItem('username', userData.username);
              sessionStorage.setItem('idaccount', userData.idaccount);
              sessionStorage.setItem('client_time', userData.client_time);
              let interval = setInterval(() => {
                this.countdown--;
                if (this.countdown <= 0) {
                  clearInterval(interval);

                  if (userData.isPlan != "true" || userData.isAddress != "true" || userData.isEmailVerify != "true" || userData.isMobileVerify != "true") {
                    this.router.navigate(['/user/verify-profile']).then(() => {
                      window.location.reload();
                    });
                  } else if (userData.newUser_status == 1 && userData.isCard != "true") {
                    this.router.navigate(['/user/credit-card-authorization']).then(() => {
                      window.location.reload();
                    });
                  } else if (userData.newUser_status == 1 && userData.type == 2 && (this.kyc_status == 0 || this.kyc_status == 2 || this.kyc_status == 3)) {
                    this.router.navigate(['/user/account-action']).then(() => {
                      window.location.reload();
                    });
                  } else if (userData.newUser_status == 1 && userData.type == 2 && this.kyc_status == 1) {
                    this.router.navigate(['/dashboards']).then(() => {
                      window.location.reload();
                    });
                  } else {
                    this.router.navigate(['/dashboards']).then(() => {
                      window.location.reload();
                    });
                  }
                }
              }, 1000);
            });
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
      //   }
      // }, 1000);
    });
  }
}



