import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

@Component({
  selector: 'app-verifyemail',
  templateUrl: './verifyemail.component.html',
  styleUrls: ['./verifyemail.component.css']
})

export class VerifyemailComponent implements OnInit {
  errMessage = "";
  responseMessage = "";
  token: any = "";
  imageShow:any = '1';
  constructor(public data: UsermanagementService, 
              public router: Router,
              private route: ActivatedRoute) {
	}

  ngOnInit(): void {
    this.imageShow = '1';
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = params.get('id');
        this.token = id;
        this.data.emailVerify({key: this.token, isEmailVerify: true}).subscribe(res => {
          
          if(res.status == 201){
            this.imageShow = '1';
            sessionStorage.clear();
            let newData = res.data;
            sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
            sessionStorage.setItem('authkey', newData.authkey);
            sessionStorage.setItem('type', newData.type);
            sessionStorage.setItem('iduser', newData.iduser);
            sessionStorage.setItem('email', res.email);
            sessionStorage.setItem('username', newData.username);
            sessionStorage.setItem('idaccount', newData.idaccount);
            if(sessionStorage.getItem('isLoggedIn')){
                this.router.navigate(['/user/verify-profile']);
            }
          }        
          else{
            this.errMessage = res.message;
            setTimeout(()=>{
              this.imageShow = '2';
              this.errMessage= "";
              //this.router.navigate(['/']);
            }, 3000);
          }
        });
    });
  }

}
