import { FormBuilder, FormGroup, Validators } from "@angular/forms";

export interface Addminute {
    id: number,
    iduser: number,
    name: string,
    fixed_charge: number,
    free_minutes: number
}

export interface HTTPAddminute {
    iduser: number,
    name: string,
    fixed_charge: number,
    free_minutes: number
}

export class AddminuteForm implements HTTPAddminute {
    public iduser: number;
    public name: string;
    public fixed_charge: number;
    public free_minutes: number;

    constructor(data: Addminute) {
        if (data == null) {

            this.iduser = parseInt(localStorage.getItem('userid'));
            this.name = "";
            this.fixed_charge = 0;
            this.free_minutes = 0;
        }
        else {
            this.iduser = parseInt(localStorage.getItem('userid'));
            this.name = data.name;
            this.fixed_charge = data.fixed_charge;
            this.free_minutes = data.free_minutes;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            iduser: [this.iduser],
            name: [this.name, Validators.required],
            fixed_charge: [this.fixed_charge, Validators.required],
            free_minutes: [this.free_minutes, Validators.required]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.iduser = fg.get("iduser").value;
            this.name = fg.get("name").value;
            this.fixed_charge = fg.get("fixed_charge").value;
            this.free_minutes = fg.get("free_minutes").value;
            return true;
        }
        else {
            return false;
        }
    }
}


// @biling address 

export interface Billingadr {
    id: number,
    iduser: number,
    address: string,
    city: string,
    unit_app: string,
    zip_code: string,
    state: string,
    country: string,
    phone_no: string,

}

export interface HTTPBillingadr {
    iduser: number,
    address: string,
    city: string,
    unit_app: string,
    zip_code: string,
    state: string,
    country: string,
    phone_no: string,
}

export class BillingadrForm implements HTTPBillingadr {
    public iduser: number;
    public address: string;
    public city: string;
    public unit_app: string;
    public zip_code: string;
    public state: string;
    public country: string;
    public phone_no: string;

    constructor(data: Billingadr) {
        if (data == null) {

            this.iduser = parseInt(localStorage.getItem('userid'));
            this.address = "";
            this.city = "";
            this.unit_app = "";
            this.zip_code = "";
            this.state = "";
            this.country = "";
            this.phone_no = "";
        }
        else {
            this.iduser = parseInt(localStorage.getItem('userid'));
            this.address = data.address;
            this.city = data.city;
            this.unit_app = data.unit_app;
            this.zip_code = data.zip_code;
            this.state = data.state;
            this.country = data.country;
            this.phone_no = data.phone_no;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            iduser: [this.iduser],
            address: [this.address, Validators.required],
            city: [this.city, Validators.required],
            unit_app: [this.unit_app, Validators.required],
            zip_code: [this.zip_code, Validators.required],
            state: [this.state, Validators.required],
            country: [this.country, Validators.required],

        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.iduser = fg.get("iduser").value;
            this.address = fg.get("address").value;
            this.city = fg.get("city").value;
            this.unit_app = fg.get("unit_app").value;
            this.zip_code = fg.get("zip_code").value;
            this.country = fg.get("country").value;
            return true;
        }
        else {
            return false;
        }
    }
}
// payment form


// export interface Payment {
//     first_name: string,
//     last_name: string,
//     email: string,
//     contact: string,
//     amount: string,
//     coupon: string,
//     address1: string,
//     address2: string,
//     city: string,
//     post_code: string,
//     state: string,
//     country: string,
// }

// export interface HTTPPayment {
//     first_name: string,
//     last_name: string,
//     email: string,
//     contact: string,
//     amount: string,
//     coupon: string,
//     address1: string,
//     address2: string,
//     city: string,
//     post_code: string,
//     state: string,
//     country: string,
// }

// export class PaymentForm implements HTTPPayment {
//     public first_name: string;
//     public last_name: string;
//     public email: string;
//     public contact: string;
//     public amount: string;
//     public coupon: string;
//     public address1: string;
//     public address2: string;
//     public city: string;
//     public post_code: string;
//     public state: string;
//     public country: string;

//     constructor(data: Payment) {
//         if (data == null) {

//             this.first_name = "";
//             this.last_name = "";
//             this.email = "";
//             this.contact = "";
//             this.amount = "";
//             this.coupon = "";
//             this.address1 = "";
//             this.address2 = "";
//             this.city = "";
//             this.post_code = "";
//             this.state = "";
//             this.country = "";

//         }
//         else {
//             this.first_name = data.first_name;
//             this.last_name = data.last_name;
//             this.email = data.email;
//             this.contact = data.contact;
//             this.amount = data.amount;
//             this.coupon = data.coupon;
//             this.address1 = data.address1;
//             this.address2 = data.address2;
//             this.city = data.city;
//             this.post_code = data.post_code;
//             this.state = data.state;
//             this.country = data.country;
//         }
//     }

//     public makeform(fb: FormBuilder): FormGroup {
//         return fb.group({
//             first_name: [this.first_name],
//             last_name: [this.last_name, Validators.required],
//             email: [this.email, Validators.required],
//             contact: [this.contact, Validators.required],
//             amount: [this.amount, Validators.required],
//             coupon: [this.coupon, Validators.required],
//             address1: [this.address1, Validators.required],
//             address2: [this.address2, Validators.required],
//             city: [this.city, Validators.required],
//             post_code: [this.post_code, Validators.required],
//             state: [this.state, Validators.required],
//             country: [this.country, Validators.required],
//         });
//     }

//     public saveForm(fg: FormGroup): boolean {
//         if (fg.valid) {
//             this.first_name = fg.get("first_name").value;
//             this.last_name = fg.get("last_name").value;
//             this.email = fg.get("email").value;
//             this.contact = fg.get("contact").value;
//             this.amount = fg.get("amount").value;
//             this.coupon = fg.get("coupon").value;
//             this.address1 = fg.get("address1").value;
//             this.address2 = fg.get("address2").value;
//             this.city = fg.get("city").value;
//             this.post_code = fg.get("post_code").value;
//             this.state = fg.get("state").value;
//             this.country = fg.get("country").value;
//             return true;
//         }
//         else {
//             return false;
//         }
//     }
// }

export interface Payment
{  
   iduser:number,   
   first_name:string,
   last_name :string, 
   email:string,   
   contact:string,  
   address1:string,
   address2:string,
   city:string,
   post_code:string, 
   country:string,
   state:string,
   amount:number,
   secret_key:string,
   timestamp:string,
   publicKey:string,
   coupon:string
}

export interface HTTPPayment
{
   iduser:number,   
   first_name:string,
   last_name :string, 
   email:string,   
   contact:string,  
   address1:string,
   address2:string,
   city:string,
   post_code:string, 
   country:string,
   state:string,
   amount:number,
   secret_key:string,
   timestamp:string,
   coupon:string
}

export class PaymentForm implements HTTPPayment
{
    public iduser:number;   
    public first_name:string;
    public last_name :string;    
    public contact:string;     
    public address1:string;
    public address2:string;
    public city:string;
    public post_code:string; 
    public country:string;
    public state:string;
    public amount:number;    
    public email:string;
    public secret_key:string;
    public timestamp:string;
    public coupon:string;
  
    constructor(data : Payment) 
    {
        if(data==null)
        {        
           this.iduser=parseInt(localStorage.getItem('userid'));;
           this.first_name="";
           this.last_name="";          
           this.contact="";           
           this.country="";
           this.address1="";
           this.address2="";          
           this.city="";           
           this.state="";
           this.amount=0;
           this.email="";  
           this.post_code="";
           this.secret_key="";
           this.timestamp="";
           this.coupon="";                    
        }
        else
        {
            this.iduser=parseInt(localStorage.getItem('userid'));;
            this.first_name=data.first_name;
            this.last_name=data.last_name;          
            this.contact=data.contact;           
            this.country=data.country;
            this.address1=data.address1;
            this.address2=data.address2;          
            this.city=data.city;           
            this.state=data.state;
            this.amount=data.amount; 
            this.email=data.email; 
            this.post_code=data.post_code;
            this.secret_key=data.secret_key; 
            this.timestamp=data.timestamp; 
            this.coupon=data.coupon  
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({
          
            iduser:[this.iduser],
            first_name:[this.first_name],
            last_name:[this.last_name],            
            contact:[this.contact],                     
            address1:[this.address1],
            country:[this.country],
            address2:[this.address2],
            city:[this.city],
            state:[this.state],
            amount:[this.amount],
            email:[this.email],
            post_code:[this.post_code],
            secret_key:[this.secret_key],
            timestamp:[this.timestamp],
            coupon:[this.coupon]
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {
           
            this.iduser=  fg.get("iduser").value;
            this.first_name=  fg.get("first_name").value;
            this.last_name=  fg.get("last_name").value;           
            this.contact=  fg.get("contact").value;           
            this.first_name=fg.get("first_name").value;
            this.last_name = fg.get("last_name").value;
            this.address1=  fg.get("address1").value;
            this.country= fg.get("country").value;
            this.address2=  fg.get("address2").value;
            this.city=  fg.get("city").value;
            this.state=  fg.get("state").value;
            this.amount=  fg.get("amount").value; 
            this.email=  fg.get("email").value; 
            this.post_code = fg.get("post_code").value; 
            this.secret_key = fg.get("secret_key").value;
            this.timestamp = fg.get("timestamp").value;
            this.coupon = fg.get("coupon").value;           
            return true;
        }
        else
        {
            return false;
        }
    }
  }
