import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { BillingService } from '../billing.service'
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { saveAs } from 'file-saver';
declare var $: any;

@Component({
  selector: 'app-closing-invoice',
  templateUrl: './closing-invoice.component.html',
  styleUrls: ['./closing-invoice.component.css']
})
export class ClosingInvoiceComponent implements OnInit {
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  filterForm: FormGroup;
  show_filter: boolean = false;
  rowdata: any;
  header: any;
  invoiceheader: any;
  users: any = [];
  responseMessage: any = "";
  errMessage: any = "";
  submitted: boolean = false;
  Closing: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_san: any = [];
  userss: any = [];
  constructor( private userService: UsermanagementService,
    public data: BillingService,
    public fb: FormBuilder) { }
    
  ngOnInit(): void {

    this.filterForm = this.fb.group({
      from_date: [''],
      to_date: [''],
      selectedUser:['']
    });
   
    // this.userService.getUsers("main").subscribe(res => {
    //   if (res.status == 200) {
    //     this.users = res.data[0];
    //   }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    // });

    this.data.getinvoice().subscribe((result) => {
      this.header = result[0].headers_details;
      this.rowdata = result[0].invoice;
    });

    this.data.getinvoicetax().subscribe((result) => {
      this.invoiceheader = result[0].headers_tax_details;
    });
    this.GetClosingDetail();
    this.getlistusers();

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'idaccount',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
  }

  
  getlistusers() {
    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
        this.users.sort((a, b) => {
          return a.idaccount - b.idaccount;
        });
        this.users.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`
          this.name_with_san.push({ idaccount: element.idaccount, Name_san: element.san + ' - ' +  fullName});
        })
        this.userss = this.name_with_san
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onItemSelect(item: any) {
    console.log(item);
  }

  GetClosingDetail(){
    this.data.closingInvoice(this.filterForm.value).subscribe((res)=>{
      if(res.status == 201){
        this.Closing = res.data
        $('#basic-datatables11a').DataTable().clear();
        $('#basic-datatables11a').DataTable().destroy();
        $.getScript('./assets/table.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);

      }else{
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);

      }
    })

  }

  OpenPdf(data:any){
    const fileExtension = data.split('.').pop();
    const pdfModal = document.getElementById('modalPdfAppeal');
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
   if (fileExtension === 'pdf') {
      modalImage123.src = data
      $(pdfModal).modal('show');
    }
  }

  filterSubmit() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return
    }
    else {
      if (this.selectedItem.length > 0) {
        this.filterForm.value.selectedUser = this.selectedItem[0].idaccount;
      }
      this.Closing = [];
      $('#basic-datatables11a').DataTable().clear();
      $('#basic-datatables11a').DataTable().destroy();
      this.data.closingInvoice(this.filterForm.value).subscribe(res => {
        if (res.status == 201) {
          this.Closing = res.data;
          $('#basic-datatables11a').DataTable().clear();
          $('#basic-datatables11a').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }

      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000)
      });
    }
  }

  clearFilter() {
    this.submitted = false
    this.filterForm.reset();
    this.filterForm.get('selectedUser').setValue('');
    this.filterForm.get('from_date').setValue('');
    this.filterForm.get('to_date').setValue('');
    this.GetClosingDetail();
    this.getlistusers();
    this.name_with_san = [];
    this.selectedItem = [];
  }
  messageshow() {
    const fromDate = this.filterForm.get('from_date').value;
    const toDate = this.filterForm.get('to_date').value;
    const currentDate = new Date();  

    function checkForMidnight() {
      const now = new Date();
      
      if (now.getHours() === 0 && now.getMinutes() === 0) {
        currentDate.setDate(now.getDate()); 
        currentDate.setMonth(now.getMonth());
        currentDate.setFullYear(now.getFullYear());
      }
    }
  
    setInterval(checkForMidnight, 60 * 1000);
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from_date').setErrors(null);
      this.filterForm.get('to_date').setErrors(null);
    }
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }

  }

  filterByUser(e) {
    this.filterForm.patchValue({
      selectedUser: e.target.value
    });
  }

  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

  downloadCSV(){
    setTimeout(() => {
      this.data.closingInvoice(this.filterForm.value).subscribe((res)=>{
        if(res.status == 201){
          let Invoicedata = res.data
          if (Invoicedata.length > 0) {
            let NewFilteredRes = Invoicedata.map((item) => {
              const { created_at, san, customer_name, invoice_number,total_amount,tax,path } = item;
              const formattedDate = created_at ? new Date(created_at).toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).split(/[-\/]/).join(created_at.includes('-') ? '-' : '/') : 'N/A';
              const San = san;
              const CustomerName = customer_name;
              const InvoceNumer = invoice_number;
              const Totalamount = total_amount;
              const Tax = tax;
              const Path = path
              return {
                'Date': formattedDate,
                'SAN': San,
                'Customer Name': CustomerName,
                'Invoice Number': InvoceNumer,
                'Total Amount': Totalamount + Tax,
                'Services Charges': Totalamount,
                'Taxes': Tax,
                'Invoice File': Path
              };
            });
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'Closing Invoice': worksheet }, SheetNames: ['Closing Invoice'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, 'Closing Invoice');
          } else {
            this.errMessage = 'No Record Available'
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        }else{
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  ngOnDestroy() {
    this.modalPdfAppeal.nativeElement.click();
  }
  
}
