import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
import { Chart } from 'chart.js';
import { Addminute, AddminuteForm } from '../billing.class';
import { Router } from '@angular/router';
import { BillingService } from '../billing.service'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';

@Component({
  selector: 'app-currentusage',
  templateUrl: './currentusage.component.html',
  styleUrls: ['./currentusage.component.css']
})
export class CurrentusageComponent extends AppComponentClass<any, any> {
  canvas: any;
  ctx: any;
  @ViewChild('mychart') mychart;

  currForm : FormGroup;
  submitted: boolean;

 

  constructor( public data: BillingService, public router: Router, public fb: FormBuilder) { 
    super(data, router, fb);
  
    this.currForm = this.fb.group({
      from_date: ['', [Validators.required]],
      to_date: ['', [Validators.required]]
    })
   }

   get f() { return this.currForm.controls; };

  onSubmit(){
    this.submitted = true;
    if(this.currForm.invalid){
      return false;
    }
    let result = this.currForm.value;
    console.log(result);
  }


  ngOnInit(): void {
  }
  ngAfterViewInit() {
    this.canvas = this.mychart.nativeElement; 
    this.ctx = this.canvas.getContext('2d');

    let myChart = new Chart(this.ctx, {
      type: 'line',
      
      data: {
        datasets: [{
          // label: 'Höhenlinie',
          backgroundColor: 'transparent',
          borderColor: '#1269db',
          fill: true,
          data: [
            { x: 1, y: 6 },
            { x: 100, y: 6 },
            { x: 200, y: 6},
            { x: 300, y: 6 },
            { x: 400, y: 6 },
            { x: 500, y: 6 },
            { x: 600, y: 6 },
            { x: 700, y: 6 },
            { x: 800, y: 6},
            { x: 900, y: 6 },
            { x: 1000, y: 6 },
            { x: 1100, y: 6 },
            { x: 1200, y: 6 },
            { x: 1300, y: 6 },
            { x: 1400, y: 6 },
          ],
        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,
          // text: 'Höhenlinie'
        },
        scales: {
          xAxes: [{
            type: 'linear',
            position: 'bottom',
           
            scaleLabel: {
              labelString: 'Länge',
              display: true,
            }
          }],
          yAxes: [{
            type: 'linear',
           
            scaleLabel: {
              labelString: 'Höhe',
              display: true
            }
          }]
        }
      }
    });
  }
}
