import { Component, OnInit } from '@angular/core';
import {BillingService} from '../billing.service'
import { Router } from '@angular/router';
import { FormBuilder, FormGroup } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';

declare var $:any;

@Component({
  selector: 'app-ratedecks',
  templateUrl: './ratedecks.component.html',
  styleUrls: ['./ratedecks.component.css']
})

export class RatedecksComponent extends AppComponentClass<any, any>{
 
  p: number = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	filterTerm: string;
 header:any;
 rowlist:any;

  constructor(public data: BillingService, public router: Router, public fb: FormBuilder) {
    super(data, router, fb);
  }

  ngOnInit(): void {

    this.data.getratedeck().subscribe((result)=>{
      this.header = result[0].headers
      this.rowlist = result[0].rate_decks
      console.log(result)
      })
  }

  onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	  } 
	  
	  onTableDataChange(event){
		  this.page = event;
	  }  
}
