import { HttpClient } from '@angular/common/http';
import { Component, ElementRef, HostListener, OnInit, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { BillingService } from '../billing.service';
import { ActivatedRoute, ParamMap } from '@angular/router';
declare var $: any;

@Component({
  selector: 'app-stripe-card',
  templateUrl: './stripe-card.component.html',
  styleUrls: ['./stripe-card.component.css'],
})
export class StripeCardComponent implements OnInit {
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  public userInfo: any;
  public userInfo1: any;
  tabheader1: any;
  tabheader2: any;
  public userdata: any;
  errMessage: any = '';
  responseMessage: any = '';
  deletecard: any = [];
  userlist: any = [];
  activecard: any = [];
  userInfo2: any;
  constructor(
    public router: Router,
    private http: HttpClient,
    public data: BillingService,
    private route: ActivatedRoute
  ) { }


  ngOnInit(): void {
    this.data.get_stripecards().subscribe((result) => {
      this.userInfo = result[0].header;
      this.userInfo1 = this.userInfo[0].name;
      this.userInfo2 = this.userInfo[1].name;
      this.tabheader1 = this.userInfo[0].tableheaders;
      this.tabheader2 = this.userInfo[1].tableheaders;
    });
    this.Delete_Active_card();
  }
  Delete_Active_card() {
    this.data.stripeCards().subscribe(
      (res) => {
        if (res.status === 200) {
          this.data.getUsers('main').subscribe((res1) => {
            this.userlist = res1.data[0];
            res.data.forEach((card) => {
              const user = this.userlist.find(
                (user) => user.idaccount === card.idaccount
              );
              if (user) {
                card.customerName = user.first_name + ' ' + user.last_name;
              }
            });
            this.deletecard = res.data.filter((card) => card.isdeleted === 1);
            this.activecard = res.data.filter((card) => card.isdeleted === 0);
            //this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = '';
            }, 5000);
            $('#basic-datatables5').dataTable().fnClearTable();
            $('#basic-datatables5').dataTable().fnDraw();
            $('#basic-datatables5').dataTable().fnDestroy();
            $('#basic-datatablesstrip').dataTable().fnClearTable();
            $('#basic-datatablesstrip').dataTable().fnDraw();
            $('#basic-datatablesstrip').dataTable().fnDestroy();
            $.getScript('./assets/tollfree.js');
          });
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      },
      (err) => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    );
  }

  delete_card(id: any, account: any) {
    const payLoad = {
      id: id,
      idaccount: account,
    };
    if (confirm("Are you sure you want delete the Card!")) {
      this.data.delete_card(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.Delete_Active_card();
          setTimeout(() => {
            this.responseMessage = '';
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    }
  }

  // to view the pdf 
  viewFile(data: any) {
    const pdfModal = document.getElementById('modalPdfAppeal');
    const modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;
    modalPdf.src = data.card_pdf;
    // Open the modal
    $(pdfModal).modal('show');
  }
  formatMonth(month: number): string {
    return month < 10 ? '0' + month : month.toString();
  }

  ngOnDestroy(){
    this.modalPdfAppeal.nativeElement.click();
  }
}
