import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { CapmaignserviceService } from '../capmaignservice.service';

declare var $: any;

@Component({
  selector: 'app-addcampaign',
  templateUrl: './addcampaign.component.html',
  styleUrls: ['./addcampaign.component.css'],
 
})
export class AddcampaignComponent implements OnInit {
   
  public brandData: any;
  campaignForm: FormGroup;
  responseMessage = "";
  brand: any;
  brandId: any;
  brandVertical: any = [];
  brandName: any;
  isDisabled: boolean = false;
  errMessage: any = "";

  constructor(private campaignService: CapmaignserviceService, 
          public fb: FormBuilder, private route: ActivatedRoute, private router: Router ) {
   }

  ngOnInit() {

    this.campaignForm = this.fb.group({
      campaign_key: ['', Validators.required],
      campaignName: ['', Validators.required],
      // vertical: ['', Validators.required],
      // description: ['', Validators.required],
      // sample1: ['', Validators.required],
      // sample2: ['', Validators.required],
      // sample3: [],
      // sample4: [],
      // sample5: [],
      // usecase: [],
      // subUsecases: [],
      brandId: [],
      // subscriberOptin: [true],
      // subscriberOptout: [true],
      // subscriberHelp: [true],
    });
 
    this.campaignService.brandVertical().subscribe(res => {
      let tmp:any=[];
      Object.entries(res.data).forEach((ele:any)=>{
        let t=ele[1];
        t["name"]=ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.brandId = params.get('id');
      this.campaignService.getSinglebrand(this.brandId).subscribe(result => {
        this.brand = result.data[0];
        this.brandName = this.brand.brand_name;
        this.campaignForm.patchValue({
            brandId: this.brandId
        })
      });
    });
  }

  addCampaign(){
    if (this.campaignForm.invalid) {
			return false;
		} 
    else {
      this.campaignService.onAddCampaign(this.campaignForm.value).subscribe(response => {
        if(response.status == 201){
          this.responseMessage = response.message;  
          this.router.navigateByUrl('/campaign/brand-details');
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
        }
        else{
          this.errMessage = response.message;  
            setTimeout(()=>{
              this.errMessage= "";
            }, 5000);
        }
      });
   }
  }
}