import { FormBuilder, FormGroup, Validators } from "@angular/forms";

export interface campaign
{
    brand_name: string,
    campaign_id: string,
    campaign_class: string,
    start_date: string,
    campaign_description: string
   
}

export interface HTTPcampaign
{
    brand_name:string,
    campaign_id: string,
    campaign_class:string,
    start_date:string,
    campaign_description:string,
   
}

export class campaignForm implements HTTPcampaign
{
    brand_name:string;
    campaign_id: string;
    campaign_class:string;
    start_date:string;
    campaign_description:string;
   

    constructor(data : campaign) 
    {
        if(data==null)
        {        
           this.brand_name="";
           this.campaign_id = "";
           this.campaign_class="";
           this.start_date="";
           this.campaign_description="";
         
        }
        else
        {         
            this.brand_name = data.brand_name;
            this.campaign_id= data.campaign_id;
            this.campaign_class = data.campaign_class;
            this.start_date = data.start_date;
            this.campaign_description = data.campaign_description;
          
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            brand_name:[this.brand_name, [Validators.required] ],
            campaign_id: [this.campaign_id, [Validators.required]],
            campaign_class:[this.campaign_class, [Validators.required]],
            start_date:[this.start_date, [Validators.required]],
            campaign_description:[this.campaign_description, [Validators.required,  Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}$")]],
          
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.brand_name=  fg.get("brand_name").value;
            this.campaign_id = fg.get("campaign_id").value;
            this.campaign_class=  fg.get("campaign_class").value;
            this.start_date=  fg.get("start_date").value;
            this.campaign_description=  fg.get("campaign_description").value;
           
            return true;
        }
        else
        {
            return false;
        }
    }
  }



  