import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
import { CapmaignserviceService } from '../capmaignservice.service'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
// import { Console } from 'node:console';

declare var $: any;

@Component({
	selector: 'app-campaign',
	templateUrl: './campaign.component.html',
	styleUrls: ['./campaign.component.css']
})



export class CampaignComponent extends AppComponentClass<any, any> {
	brandId: any = null;
	/* searchText = { count: 0 };
	filtre: string; */
	campaigns: any;
	/* p: number = 1;
	page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25, 50, 100];
	filterTerm: string;
	filterTerm1: string; */
	responseMessage = "";
	collection: any;
	heading: any;
	main_heading: any;
	isCampaign: boolean = false;
	errMessage: any = "";
	campaign_key: any;
	iduser: any;
	campDid: any = [];


	constructor(public data: CapmaignserviceService,
		public router: Router, public fb: FormBuilder,
		private route: ActivatedRoute) {
		super(data, router, fb);
	}

	ngOnInit(): void {

		this.data.getcampaign().subscribe((result) => {
			this.collection = result[1]
			$.getScript('./assets/table.js');
			this.heading = result[0].headers
			this.main_heading = result[0].users
		});

		this.route.paramMap.subscribe((params: ParamMap) => {
			this.brandId = params.get('id');
			if (this.brandId) {
				this.data.onGetCampaigns(this.brandId).subscribe(result => {
					if (result.status == 200) {
						if (result.data.length > 0) {
							this.campaigns = result.data;
							$.getScript('./assets/table.js');
							this.isCampaign = true;
						}
					}
					else {
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}
			else {
				this.data.GetCampaignsList().subscribe(result => {
					if (result.status == 200) {
						var userID = this.data.iduser;
						if (result.data.length > 0) {
							this.campaigns = result.data;
							$.getScript('./assets/table.js');
							this.isCampaign = true;
						}
					}
					else {
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}

		});

	}

	/**
	 * It will delete a campaign
	 */
	getCampRegDID(camp: any, userid: any) {
		this.campaign_key = camp
		this.campDid = [];
		this.data.getCampaignDID(camp, userid).subscribe((res) => {
			if (res.status == 200) {
				this.campDid = res.data;
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	onDeleteCampaign(campaign_key: any): any {
		if (confirm("Are You Sure, You want delete this campaign?")) {
			this.data.onDeleteCampaign(campaign_key).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					window.location.reload();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
		else {
			return false
		}
	}
}

