import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})

export class CapmaignserviceService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });
  iduser: any[];

  constructor(public http: HttpClient) {
    super(http)
  }

  @LoaderEnabled()
  brandDCA(): Observable<any> {
    this.appmod = "brandDCA";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandRelationship(): Observable<any> {
    this.appmod = "brandRelationship";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVettingClass(): Observable<any> {
    this.appmod = "vettingClass";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVettingProvider(): Observable<any> {
    this.appmod = "extVettingProvider";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  brandEntityType(): Observable<any> {
    this.appmod = "brandEntity";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVertical(): Observable<any> {
    this.appmod = "brandVertical";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  altBusinessIdType(): Observable<any> {
    this.appmod = "altBusinessIdType";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSinglebrand(brandId): Observable<any> {
    this.appmod = "brand";
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrand(): Observable<any> {
    this.appmod = 'getbrands';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandVetting(payLoad): Observable<any> {
    this.appmod = 'getBrandsVettingList';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getVettingClass(payLoad): Observable<any> {
    this.appmod = 'getVettingClass';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getVettingPartner(payLoad): Observable<any> {
    this.appmod = 'getVettingPartner';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  //@LoaderEnabled()
  updateVetting(data?: any): Observable<any> {
    this.appmod = "updateVettingForStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  onAddBrand(data: any): Observable<any> {
    let apiURL = environment.SERVER + "addbrand";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'brandcreate';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }

  @LoaderEnabled()
  onBrandRegistefffr(data: any): Observable<any> {
    let apiURL = environment.SERVER + "registerbrand";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'brandcreate';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }
  @LoaderEnabled()
  onBrandRegister(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'registerbrand';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpheaders });
  }
  @LoaderEnabled()
  onAddCspId(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'updateCSPID';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }

  @LoaderEnabled()
  onGetCampaign(): Observable<any> {
    this.appmod = 'campaignsList';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onGetCampaigns(brandId): Observable<any> {
    this.appmod = 'brandCampaign';
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetCNPCampaignsList(): Observable<any> {
    this.appmod = 'cnpCampaign';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetCampaignsList(): Observable<any> {
    this.appmod = 'campaignsList';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetCampaignsListForAdmin(type:string): Observable<any> {
    this.appmod = 'campaignData';
    let result = super.getService(type);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onAddCampaign(data: any): Observable<any> {
    let apiURL = environment.SERVER + "addcampaign";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'addcampaign';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }

  @LoaderEnabled()
  applyNewVetting(data: any): Observable<any> {
    let apiURL = environment.SERVER + "applyVetting";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'addcampaign';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }
  @LoaderEnabled()
  importVetting(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'importVetting';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }

  @LoaderEnabled()
  onRegisterCampaign(data: any): Observable<any> {
    let apiURL = environment.SERVER + "registercampaign";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'addcampaign';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }

  @LoaderEnabled()
  onDeleteCampaign(data: any): Observable<any> {
    this.appmod = 'deletecampaign';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  DeleteBrand(data: any): Observable<any> {
    this.appmod = 'deleteBrand';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignCases(): Observable<any> {
    this.appmod = "campcases";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignDIDCount(campaign_key, userID): Observable<any> {
    this.appmod = "getCampaignDIDCount";
    let result = super.getService(campaign_key, userID);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getCampaignDID(campaign_key, userID): Observable<any> {
    this.appmod = "getCampaignDID";
    let result = super.getService(campaign_key, userID);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCspId(): Observable<any> {
    let apiUrl = environment.SERVER + 'getCSP';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  getBrands(): Observable<any> {
    return this.http.get('./assets/brand.json');
  }

  getcampaign(): Observable<any> {
    return this.http.get('./assets/campaign.json');
  }
}
