import { Component, OnInit } from '@angular/core';
import { CapmaignserviceService } from '../capmaignservice.service';
import { Router, ActivatedRoute } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';

@Component({
  selector: 'app-cnp-campaign',
  templateUrl: './cnp-campaign.component.html',
  styleUrls: ['./cnp-campaign.component.css']
})
export class CnpCampaignComponent extends AppComponentClass<any, any> {

  /* brandId: any=null; */
  /* searchText = { count: 0 };
  filtre: string; */
  campaigns: any;
  /* p: number = 1;
  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [ 25, 50, 100]; */
  /* filterTerm: string;
  filterTerm1: string; */
  responseMessage = "";
  collection: any;
  heading: any;
  main_heading: any;
  isCampaign: boolean = false;
  errMessage: any = "";
  campaign_key: any;
  iduser: any;
  campDid: any = [];



  constructor(public data: CapmaignserviceService,
    public router: Router, public fb: FormBuilder, private route: ActivatedRoute) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    this.data.getcampaign().subscribe((result) => {
      this.collection = result[1]
      $.getScript('./assets/table.js');
      this.heading = result[0].headerCNP
      this.main_heading = result[0].users
    });

    this.data.GetCNPCampaignsList().subscribe(result => {
      if (result.status == 200) {
        var userID = this.data.iduser;
        if (result.data.length > 0) {
          this.campaigns = result.data;
          $.getScript('./assets/table.js');
          this.isCampaign = true;
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });



  }

  getUser(camp: any, userid: any) {
    this.campaign_key = camp
    const campaign_key = camp;
    const userID = userid;
    this.campDid = [];
    this.data.getCampaignDID(this.campaign_key, userID).subscribe((res) => {
      if (res.status == 200) {
        this.campDid = res.data;        
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

  }

  /*  onDeleteCampaign(campaign_key){
     if(confirm("Are You Sure ?")){
     this.data.onDeleteCampaign(campaign_key).subscribe(res => {
       if(res.status == 201){
         this.ngOnInit();
         this.responseMessage = res.message;
         setTimeout(()=>{
           this.responseMessage= "";
         }, 5000);
       }
       else{
         this.errMessage = res.message;
         setTimeout(() => {
           this.errMessage = "";
         }, 5000);
       }
       }, err  => {
         this.errMessage = err.message;
         setTimeout(()=>{
         this.errMessage= "";
         }, 5000);
       });
     }
     else{
     return
     }
   } */


}