import { Component } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { CampaignsService } from '../campaigns.service';

@Component({
  selector: 'app-brand',
  templateUrl: './brand.component.html',
  styleUrls: ['./brand.component.css']
})

export class BrandComponent extends AppComponentClass<any, any>  {
  CompanydetailsForm: FormGroup;
  ContactdetailsForm: FormGroup;
  submitted: boolean = false;
  
  constructor(public data: CampaignsService, public router: Router,  
    public fb: FormBuilder,  private route: ActivatedRoute)
{

super(data, router, fb);

}

  ngOnInit(): void {
    this.CompanydetailsForm = this.fb.group({
      brndname: ['', [Validators.required]],
      vertical_type: ['', [Validators.required]],
      legal_organization: ['', [Validators.required]],
      country_registration: ['', [Validators.required]],
      ein: ['', [Validators.required]],
      ein_issuing_country: ['', [Validators.required]],
      duns_giin_number: ['', [Validators.required]],
      duns_number: ['', [Validators.required]],
      address_street: ['', [Validators.required]],
      city: ['', [Validators.required]],
      state: ['', [Validators.required]],
      stock_symbol: ['', [Validators.required]],
      stock_exchange: ['', [Validators.required]],
      website: ['', [Validators.required]],
      reference_id: ['', [Validators.required]]
    });

    this.ContactdetailsForm = this.fb.group({
      supportMail: ['', [Validators.required]],
      phone_number: ['', [Validators.required]],
    });
  }


  onSubmit() {
    console.log(this.CompanydetailsForm.value)
  }


  onSave() {
    console.log(this.ContactdetailsForm.value)
  }
}
