import { Component } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { CampaignsService } from '../campaigns.service';

@Component({
  selector: 'app-brands',
  templateUrl: './brands.component.html',
  styleUrls: ['./brands.component.css']
})
export class BrandsComponent extends AppComponentClass<any, any> {
    page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
	header: any;
	brands: any = [];
	errMessage: any = "";

	constructor(public data: CampaignsService, public router: Router,  public fb: FormBuilder,  private route: ActivatedRoute)
    {
	super(data, router, fb);
}

  ngOnInit(): void {

	this.data.get_brands().subscribe((result)=> {
		this.header = result[0].headers;
	});

	this.data.getBrand().subscribe(result => {
		if(result.status == 200){
		   this.brands = result.data;
		   $.getScript('./assets/table.js');
		}
		else{
		   this.errMessage = result.message;
		   setTimeout(() => {
			   this.errMessage = "";
		   }, 5000);
		}
	});
  }


  
 
}
