import { DemoMaterialModule } from './../demo-material-module';
import { NgModule } from '@angular/core';
import { CommonModule, DatePipe } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { RouterModule } from '@angular/router';
import { HomeService } from './home.service';
import { DashboardComponent } from './dashboard/dashboard.component';
import { DashboardRoutes } from './dashboard.routing';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { InformationComponent } from './dashboard1/information/information.component';
import { IncomeComponent } from './dashboard1/income/income.component';
import { UserstatisticComponent } from './dashboard1/userstatistic/userstatistic.component';
import { DailysaleComponent } from './dashboard1/dailysale/dailysale.component';
import { LocationComponent } from './dashboard1/location/location.component';
import { Dashboard1Component } from './dashboard1/dashboard1/dashboard1.component';
import { SharedModule } from '../shared/shared.module';
import { ReportService } from '../shared/report/report.component';
import { NgApexchartsModule } from 'ng-apexcharts';
import { OrderPipe } from './orderPipe.pipe';

// import { UsageComponent } from './graphs/usage/usage.component';
// import { SmsComponent } from './graphs/sms/sms.component';
// import { CallsComponent } from './graphs/calls/calls.component';
// import { SendReceiveSmsComponent } from './graphs/send-receive-sms/send-receive-sms.component';
// import { IncomingOutgoingCallComponent } from './graphs/incoming-outgoing-call/incoming-outgoing-call.component';
// import { TransactionsHistoryComponent } from './graphs/transactions-history/transactions-history.component';
// import { DailyUsageComponent } from './graphs/daily-usage/daily-usage.component';
// import { Dashboard4Component } from './dashboard4/dashboard4.component';

@NgModule({
    imports: [
        FormsModule,
        CommonModule,
        NgbModule,
        RouterModule,
        SharedModule,
        RouterModule.forChild(DashboardRoutes),
        NgApexchartsModule,

        DemoMaterialModule

    ],
    declarations: [
        DashboardComponent,
        InformationComponent,
        IncomeComponent,
        UserstatisticComponent,
        DailysaleComponent,
        LocationComponent,
        Dashboard1Component,
        OrderPipe
        // Dashboard4Component,
        // UsageComponent,
        // SmsComponent,
        // CallsComponent,
        // SendReceiveSmsComponent,
        // IncomingOutgoingCallComponent,
        // TransactionsHistoryComponent,
        // DailyUsageComponent
    ],
    providers: [HomeService, DatePipe, ReportService, OrderPipe]
})
export class DashboardModule { }
