import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from '../shared/service/AppService.class';

@Injectable()
export class HomeService  extends AppService<any> {

  constructor(protected http : HttpClient) {
    super(http);
  }

  public getData():Observable<any>{
    return this.http.get<any>('./assets/jsonData/campaign.json');
  }

  public getCampaignsInfo():Observable<any>{
    this.appmod="lib/dashboardcampaign";
    return super.getService();
  }

  public getLeadInfo(type:string, filter:any):Observable<any>{
    this.appmod="reports/leads";
    return super.getService(type, filter);
  }

  public getCallDial(type:string, filter:any):Observable<any>{
    this.appmod="reports/calls";
    return super.getService(type, filter);
  }

  public getISDNError(type:string, filter:any):Observable<any>{
    this.appmod="reports/isdn";
    return super.getService(type, filter);
  }

  public getLive(type:string, filter:any):Observable<any>{
    this.appmod="reports/live";
    return super.getService(type, filter);
  }

  public getLiveWidget():Observable<any>{
    this.appmod="reports/livewidget";
    return super.getService();
  }

  public getCallDist(type:string, filter:any):Observable<any>{
    this.appmod="reports/dist";
    return super.getService(type, filter);
  }

  public getCampaign():Observable<any>{
    this.appmod="lib/optcampaign";
    return super.getService();
  }

  public getChartReportData(sdata: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "custom/get_chart_report_data";
    let data = this.saveService(sdata);
    this.appmod = tmp;
    return data;
  }
}