import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { AppService } from '../shared/service/AppService.class';

@Injectable({
  providedIn: 'root'
})
export class DownloadreportService extends AppService<any>{

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) { 
    super(http)
  }

  get_typestatus(): Observable<any> {
    return this.http.get('./assets/downloadReport.json')
  }

  @LoaderEnabled()
  getUsers(type: string): Observable<any> {
    this.appmod = "user";
    let tmp = this.getService(type);
    this.appmod = "usermanagement";
    return tmp;
  }

  @LoaderEnabled()
  get_downloadetails(data:any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "getreptdownload";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyFilter(data: any): Observable<any> {
    this.appmod = "downloadreportfilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
}
