import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators} from '@angular/forms';
import { InboundService } from '../inbound.service'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';

declare var $:any;
@Component({
  selector: 'app-completecall',
  templateUrl: './completecall.component.html',
  styleUrls: ['./completecall.component.css']
})
export class CompletecallComponent extends AppComponentClass<any, any> {
  p: number = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	filterTerm: string;
  header: any;
  listdata: any;
  public completeForm: FormGroup;
  public complete: any;
  public show: boolean = false;
  public show1: boolean = false;
  public hide: boolean = false;
  submitted: boolean;

  constructor(public fb: FormBuilder, public data: InboundService, public router: Router) {
    super(data, router, fb) 
    this.completeForm = this.fb.group({
      from_date: ['', Validators.required],
      to_date: ['', Validators.required],
      to_did: ['', Validators.required],
      call_id: ['', Validators.required],
    })
  }

  ngOnInit(): void {
    this.data.getcomplete().subscribe((result) => {
      this.complete = result[1] ;
      // this.header = result[0].headers_details;
      // this.listdata = result[0].complete_details;
      console.log(result)
    });
  }

  get f() { return this.completeForm.controls; };

  onsubmit() {
    this.submitted = true;
		if (this.completeForm.valid) {
      let data = this.completeForm.value;
      console.log(data);
			this.data.getcomplete().subscribe((result) => {
        this.header = result[0].headers_details;
        // this.listdata = result[0].complete_details;
        // console.log(this.listdata)
        this.data.callDetails(data).subscribe(result=>{
          console.log("result::", result)
        })
        this.hide = !this.hide
      });
      // this.data.callDetails(this.completeForm.valid).subscribe(result=>{
      //   console.log("result::", result)
      // })
		} else {
      return false;
    } 
    
  }

  toggle() {
    this.show = !this.show;

  }

  tablehide(){
    // this.show1 = !this.show1;
    this.hide = !this.hide
  }

  onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	
	
	  } 
	  
	  onTableDataChange(event){
		this.page = event;
		
	  } 
}
