import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { InboundService } from '../inbound.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;
@Component({
  selector: 'app-did-history',
  templateUrl: './did-history.component.html',
  styleUrls: ['./did-history.component.css'],
})
export class DidHistoryComponent extends AppComponentClass<any, any> {

  public didLogheader: any;
  public submitted: boolean = false;
  LogData: any = [];
  tableSize = 50;
  tableSizes = [50, 100, 150];
  responseMessage: any = "";
  errMessage: any = "";
  page: number;
  show: boolean = false;
  isAdmin: boolean = false;
  filterForm: FormGroup;
  stateList: any;
  users: any = [];
  users1: any = [];
  didLogData: any = [];
 dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  constructor(
    public fb: FormBuilder,
    public data: InboundService,
    private userService: UsermanagementService,
    public router: Router) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    this.data.getdid().subscribe((result) => {
      this.didLogheader = result[0].did_history;
    });
    //state list data
    this.data.getStates().subscribe(res => {
      this.stateList = res.data;
    });
    //user list data
    this.userService.getidAccount().subscribe(res => {
      if (res.status == 200) {
        this.users = res.data;

        this.users1 = res.data.map(item => ({
          iduser: `${item.iduser}-${item.idaccount}`,
          users: `${item.san} - ${item.first_name} ${item.last_name}`
        }))
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
    //login user details
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    let user = JSON.parse(isLoggedIn);
    if (user.type == '1') {
      this.isAdmin = true;
    }
    else {
      this.isAdmin = false;
    }

    // form validation
    this.filterForm = this.fb.group({
      fromDate: new FormControl(this.startDate()),
      toDate: new FormControl(this.current_datetime()),
      selectedUser: new FormControl(''),
      didnumber: new FormControl(''),
      didnpa: new FormControl('', [Validators.minLength(3)]),
      // selectState: new FormControl(''),
      // selectSMS: new FormControl('')
    }
    );
    //Table data
    this.data.getdidData(this.filterForm.value).subscribe((response) => {
      if (response.status == 200) {
        $('#basic-datatabless').dataTable().fnClearTable();
        $('#basic-datatabless').dataTable().fnDraw();
        $('#basic-datatabless').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        this.LogData = response.data;
        this.LogData.forEach((ele: any) => {
          let dids = ele.did.replace(/[^\d]/g, '');
          this.didLogData.push({ 'did': dids, 'provider': ele.provider, 'account_id': ele.account_id, 'iduser': ele.iduser });
        });
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    });

     this.dropdownSettings = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'users',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true,
      defaultOpen: false,
    };
  }
  //On click filter display field
  showField() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  // selectedFromDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterForm.get("toDate").setValidators(Validators.required);
  //     this.filterForm.get("toDate").updateValueAndValidity();
  //   }
  // }

  // selectedToDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterForm.get("fromDate").setValidators(Validators.required);
  //     this.filterForm.get("fromDate").updateValueAndValidity();
  //   }
  // }

  // static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
  //   return (c: AbstractControl): { [key: string]: boolean } | null => {
  //     const date1 = c.get(fromDate).value;
  //     const date2 = c.get(toDate).value;
  //     if ((date1 !== null && date2 !== null) && date1 > date2) {
  //       return validatorField;
  //     }
  //     return null;
  //   };
  // }

  messageshow() {
    const fromDate = this.filterForm.get('fromDate').value;
    const toDate = this.filterForm.get('toDate').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('fromDate').setErrors(null);
      this.filterForm.get('toDate').setErrors(null);
    }
  }

  filterByUser(e) {
    this.filterForm.patchValue({
      selectedUser: e.target.value
    });
  }

  clearFilter() {
    this.ngOnInit();
    // this.filterForm.reset();
  }

  filterSubmit() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return false;
    }
    else {
      this.filterForm.value.selectedUser = this.filterForm.value.selectedUser?.[0]?.iduser || '';
      this.data.getdidData(this.filterForm.value).subscribe(res => {
        if (res.status == 200) {
          $('#basic-datatabless').dataTable().fnClearTable();
          $('#basic-datatabless').dataTable().fnDraw();
          $('#basic-datatabless').dataTable().fnDestroy();
          $.getScript('./assets/table.js');
          this.LogData = res.data;
          this.LogData.forEach((ele: any) => {
            let dids = ele.did.replace(/[^\d]/g, '');
            this.didLogData.push({ 'did': dids, 'provider': ele.provider, 'account_id': ele.account_id, 'iduser': ele.iduser });

          });         
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }

      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000)
      });
    }
  }
  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}
}
