import { Action, createFeatureSelector, createSelector } from '@ngrx/store';
import { InboundActions, SET, REMOVE, RESET, ADD, REMOVE_ITEMS } from './inbound.action';
import { Cart } from './inbound.class';
// import * as fromRoot from '../reducer';
 
export interface inboundState {
    cart: Cart[],
}

const initialState: inboundState = {
    cart: []
};

export function inboundReducer(state = initialState, action: InboundActions) {
  switch (action.type) {
    case SET:
      return {
        ...state,
        cart: action.payload
      };
    case ADD: 
        let carts: any = action.payload;
        // let data1 = state.cart.filter(item1 => {
        //     if(item1.did != item.phone_number){
        //       return item
        //     }
        // });
        // let newItem: any;
        // carts.forEach(item => {
        //      newItem = {idaccount: 0, id_cart: 0, did: item.phone_number, provider: '', disable: ''};
        // });
        return {
          ...state,
          cart: [...state.cart, ...carts]
        };

    // case ADDALL: 
    //     // let newItems: any = [];
    //     let items: any = action.payload;
    //     // items.forEach(element => {
    //     //   newItems.push({idaccount: 0, id_cart: 0, did: element.phone_number, provider: '', disable: ''})
    //     // });
    //     return {
    //       ...state,
    //       cart: [...state.cart, ...items]
    //     };

    case REMOVE:
        let data = state.cart.filter((item, idx)=> {
            if(item.did != action.payload.did){
              return item
            }
        });
        return {
          ...state,
          cart: data
        };

    case REMOVE_ITEMS:  
    let items = state.cart.filter(item => {
        if(item.did != action.payload.did){
          return item
        }
    });
    return {
      ...state,
      cart: items
    };
    
    case RESET:
        return {
          ...state,
          cart: action.payload
        };
      
    default:
        return {
          ...state,
          cart: state
        };
  }
}

export const getInboundState = createFeatureSelector<inboundState>('inbound');
export const getCartItems = createSelector(getInboundState, (state: inboundState) => state.cart);