import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { map, take } from 'rxjs/operators';
import { Store } from '@ngrx/store';
import * as fromInbound from '../inbound/inbound.reducer';

@Injectable({
  providedIn: 'root'
})

export class InboundService extends AppService<any> {

  constructor(public http: HttpClient, private store: Store<fromInbound.inboundState>) {
    super(http)
  }


  @LoaderEnabled()
  onDidLocationInfo(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'didlocationinfo';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }


  // @LoaderEnabled()
  // onGetBuyffDids(filter?: any): Observable<any> {
  //   let tmp = this.appmod;
  //   this.appmod = 'dids';
  //   let result = super.getService();
  //   this.appmod = tmp;
  //   return result;
  // }

  @LoaderEnabled()
  onGetBuyDids(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "dids";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  onGetMultiSearch(data: any): Observable<any> {
    let bodyFormData = new FormData();
    bodyFormData.append('data', JSON.stringify(data));
    bodyFormData.append('profile_pic', data.file);

    const apiURL = environment.SERVER + 'getMultiSearch';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, bodyFormData, { headers: httpHeaders });
  }


  @LoaderEnabled()
  onGetBuySMSDids(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "smsdids";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }


  @LoaderEnabled()
  exportDID(data: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "exportdid";
    return this.http.post(apiUrl, { data: data }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  exportorderDID(data: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "exportorderdid";
    return this.http.post(apiUrl, { data: data }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  onDisconnectDid(did, iduser, idaccount): Observable<any> {
    const apiURL = environment.SERVER + 'disconnect';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, { DID: did, iduser: iduser, idaccount:idaccount }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }
  @LoaderEnabled()
  enableDisable(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'didienable';
    let result = super.updateService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  onEnable_service(data?: any) {
    this.appmod = "EnableTFsms";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  onDisable_service(data?: any) {
    this.appmod = "disableTFsms";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  callDetailRecord(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'details_cdr';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  updateDID(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "updatedid";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onGetCampaigns(brandId): Observable<any> {
    this.appmod = 'brandCampaign';
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

  getCampaignDIDCount(campaignCount, idaccount): Observable<any> {
    this.appmod = 'getCampaignDIDCount';
    let result = super.getService(campaignCount, idaccount);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignDID(campaign_key, userID): Observable<any> {
    this.appmod = "getCampaignDID";
    let result = super.getService(campaign_key, userID);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaigns(iduser): Observable<any> {
    this.appmod = 'getCampaign';
    let result = super.getService(iduser);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSmsProvider(iduser): Observable<any> {
    this.appmod = 'smsProvider';
    let result = super.getService(iduser);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetConnections(id: any): Observable<any> {
    this.appmod = 'get_connections';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }


  // @LoaderEnabled()
  // updateWebkey(data: any): Observable<any> {
  //   this.appmod = "updateWebkey";
  //   let result = super.updateService(data);
  //   this.appmod = "";
  //   return result;
  // }

  @LoaderEnabled()
  GetConnectionsByAccount(id: any): Observable<any> {
    this.appmod = 'get_connections_by_account';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  SMSrequest(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'smsrequest';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  updateSelectedDids(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "selected_dids";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  disconnectSelectedDids(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "disconnect-dids";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  listConnections(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'listconnectionUI';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }
  @LoaderEnabled()
  getconnection(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'getconnection';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }
  singleConnections(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'singledefconn';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }


  onGetAllKeyByConnKey(data): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'get_all_Key';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  searchDIDByRate(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'searchbyrate';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  searchDIDByNpx(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'searchbynpa';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  onAddTOCart(did: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'addtocart';
    let result = super.saveService(did);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  enableSMS(data): Observable<any> {
    const apiURL = environment.SERVER + 'enablesms';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, data, { headers: httpHeaders });
  }
  @LoaderEnabled()
  enableSMSAdmin(data): Observable<any> {
    const apiURL = environment.SERVER + 'enablesmsadmin';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  reProvisioningSMS(data): Observable<any> {
    const apiURL = environment.SERVER + 're-provisioning-sms';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  disableSMS(id: any, iduser: any): Observable<any> {
    const apiURL = environment.SERVER + 'disablesms';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { DID: id, iduser: iduser } });
  }

  @LoaderEnabled()
  disableSMSAdmin(id: any, iduser: any,account_id:any): Observable<any> {
    const apiURL = environment.SERVER + 'disablesmsadmin';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { DID: id, iduser: iduser,idaccount:account_id } });
  }

  @LoaderEnabled()
  uploadDid(uploadDid: any, file: File | any): Observable<any> {
    let bodyFormData = new FormData();
    bodyFormData.append('uploadDid', JSON.stringify(uploadDid));
    bodyFormData.append('profile_pic', file);

    const apiURL = environment.SERVER + 'uploadDid';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, bodyFormData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  onAddAllToCart(did: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'addAllToCart';
    let result = super.saveService(did);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  onTfRequest(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'BuyTollfree';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getCart(): Observable<any> {
    this.appmod = "carts";
    let result = this.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onDeleteCart(id: any): Observable<any> {
    this.appmod = "deletecart";
    let result = this.deleteService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onClearCart(): Observable<any> {
    this.appmod = environment.SERVER + "clearcart";
    let httpHeaders = new HttpHeaders({
    });
    let result = this.http.delete(this.appmod, { headers: httpHeaders });
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onBuyDID(did): Observable<any> {
    const apiURL = environment.SERVER + 'buy';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, did, { headers: httpHeaders });
  }

  @LoaderEnabled()
  CreateGroupOrder(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'create_group_order';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  BuyAllDIDs(did): Observable<any> {
    const apiURL = environment.SERVER + 'buy_dids';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, did, {
      headers: httpHeaders
    });
  }
  checkDidOrder(did): Observable<any> {
    const apiURL = environment.SERVER + 'checkDidOrder';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiURL, did, {
      headers: httpHeaders
    });
  }

  updateData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  callDetails(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'details_cdr';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  onDeleteItems(items: any): Observable<any> {
    const apiURL = environment.SERVER + 'deletecartItems';
    let httpHeaders = new HttpHeaders({

    });

    return this.http.post(apiURL, items, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getStates(): Observable<any> {
    const apiURL = environment.SERVER + 'getStates';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  GetRateCenter(State): Observable<any> {
    const apiURL = environment.SERVER + 'getratecenter';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: { State: State } });
  }

  @LoaderEnabled()
  onTollFreeNumber(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'searchtollfree';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  GetOrdersHistory(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "get_orders_history";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  ViewOrderHistory(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "view_order_history";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  getDisconnectedDid(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'getDisconnectedDid';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  restoreDisconnectDid(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "restoreDisconnectDid";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetPortPIn(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'getportOut';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }

  // @LoaderEnabled()
  // getdidData(filter?: any): Observable<any> {
  //   let tmp = this.appmod;
  //   this.appmod = 'historyDid';
  //   let result = super.getService();
  //   this.appmod = tmp;
  //   return result;
  // }


  @LoaderEnabled()
  getdidData(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "historyDid";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  // @LoaderEnabled()
  // getDidHistoryDetails(payload: any): Observable<any> {
  //   let tmp = this.appmod;
  //   this.appmod = 'historyDid_details';
  //   let result = super.getService(payload);
  //   this.appmod = tmp;
  //   return result;
  // }

  @LoaderEnabled()
  getCustomerHistoryDetails(payload: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'customerHistory_details';
    let result = super.getService(payload);
    this.appmod = tmp;
    return result;
  }

  /*  @LoaderEnabled()
   autoRenewalDetails(payload: any): Observable<any> {
     let tmp = this.appmod;
     this.appmod = 'autoRenewalDetails';
     let result = super.getService(payload);
     this.appmod = tmp;
     return result;
   } */

  @LoaderEnabled()
  getCampaignHistoryDetails(payload: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'campaignHistory_details';
    let result = super.getService(payload);
    this.appmod = tmp;
    return result;
  }

  public getinbound(): Observable<any> {
    return this.http.get('./assets/configure.json');
  }

  public getdid(): Observable<any> {
    return this.http.get('./assets/did.json');
  }

  get_cdr(): Observable<any> {
    return this.http.get('./assets/inboundcdr.json');
  }

  public getnumber(): Observable<any> {
    return this.http.get('./assets/getnumber.json');
  }

  public getinboundprofile(): Observable<any> {
    return this.http.get('./assets/inboundprofile.json');
  }

  public getmanagesite(): Observable<any> {
    return this.http.get('./assets/managesites.json');
  }

  public getipaddress(): Observable<any> {
    return this.http.get('./assets/ip_address.json');
  }

  public getcnamout(): Observable<any> {
    return this.http.get('./assets/cnamout.json');
  }

  public getcomplete(): Observable<any> {
    return this.http.get('./assets/complete.json');
  }

  public getuncomplete(): Observable<any> {
    return this.http.get('./assets/uncomplete.json');
  }

  public getinboundrate(): Observable<any> {
    return this.http.get('./assets/inboundrate.json');
  }

  public gettaxrate(): Observable<any> {
    return this.http.get('./assets/taxrate.json');
  }

  getCdr(): Observable<any> {
    return this.http.get('./assets/cdr.json');
  }

  @LoaderEnabled()
  summeryCdrForm(data?: any): Observable<any> {
    this.appmod = 'SummeryCdrForm';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "orderhistoryfilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  onGetshortcode(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "getscode";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  onExportSCode(data: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "onExportSCode";
    return this.http.post(apiUrl, { data: data }, { headers: httpHeaders });
  }

  public getshortcode(): Observable<any> {
    return this.http.get('./assets/shortcodes.json');
  }

  // add new service to import did
  get_didImport(): Observable<any> {
    return this.http.get('./assets/did_import.json')
  }

  // to get rates 
  @LoaderEnabled()
  Getrates(iduser): Observable<any> {
    this.appmod = 'getrates';
    let result = super.getService(iduser);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getDIDActionLog(): Observable<any> {
    this.appmod = 'didactionLog';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  checkDIDduplicacy(data?:any): Observable<any> {
    this.appmod = 'checkduplicate';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }
}