import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { InboundService } from '../inbound.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ip, ipForm } from '../inbound.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';


declare var $:any;

@Component({
  selector: 'app-ipaddress',
  templateUrl: './ipaddress.component.html',
  styleUrls: ['./ipaddress.component.css']
})
export class IpaddressComponent extends AppComponentClass<ip, ipForm> {
	label: Observable<any>;
	iplist: any;
	ipfield: any;
	p: number = 1;
	// defaultSelect : any = 1;
	public show1: boolean = false;
	page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25, 50, 100];
	filterTerm: string;
  public show: boolean = false;
  public buttonName: any = "Add";
  public ipForm: FormGroup;
  public ipaddress: any;
  public submitted: boolean = false;

  constructor(public data: InboundService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new ipForm(res);
				this.keyfield = res.id;
				this.ipForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new ipForm(null);
				this.keyfield = -1;
				this.ipForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getipaddress().subscribe((result) => {
      this.ipaddress = result[0].headers_details  
	  this.iplist = result[0].ip_details  
	  this.ipfield = result[1]  
      console.log(result)
    });

    // $(document).ready(function() {
	// 		$('#basic-datatables').DataTable({
	// 		});
	// 	});
  }
 toggle() {
    this.show = !this.show;

    // CHANGE THE NAME OF THE BUTTON.
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }

  // @to edit the record
	editRow(rowdata: any): void {
		this.show = true
		this.Edit(rowdata)
	}

	get f() { return this.ipForm.controls; };

  // @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.ipForm.invalid) {
			return false;
		} else {
			let input_data = [this.cdata]
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.ipForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	// Dynamic Form
	saveForm(data: any){
		console.log(data, "data");
	}

	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	} 
	  
	onTableDataChange(event){
		this.page = event;
	} 

	click(){
		this.show1 = !this.show1;
	}
}

